<?php
require_once 'includes/site_data.php';
require_once 'includes/portfolio_data.php';

// Get dynamic content
$about_data = getAboutData();
$contact_info = getContactInfo();
$portfolio_items = getPortfolioItems();
$site_title = getSiteSetting('site_title', 'Portfolio - Manisha | Graphic Designer');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($site_title); ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/responsive.css">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar" id="navbar">
        <div class="nav-container">
            <div class="nav-logo">
                <a href="index.php"><?php echo safeOutputWithDecode($about_data['name'] ?? 'Manisha'); ?></a>
            </div>
            <div class="nav-menu" id="nav-menu">
                <a href="index.php" class="nav-link">Home</a>
                <a href="about.php" class="nav-link">About</a>
                <a href="portfolio.php" class="nav-link active">Portfolio</a>
                <a href="contact.php" class="nav-link">Contact</a>
            </div>
            <div class="hamburger" id="hamburger">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
    </nav>

    <!-- Portfolio Hero Section -->
    <section class="portfolio-hero">
        <div class="container">
            <div class="portfolio-hero-content">
                <h1>My <span class="highlight">Portfolio</span></h1>
                <p class="lead">
                    A collection of my best work showcasing creativity, attention to detail, 
                    and passion for impactful visual design across various mediums.
                </p>
            </div>
        </div>
    </section>

    <!-- Portfolio Filter -->
    <section class="portfolio-filter">
        <div class="container">
            <div class="filter-buttons">
                <button class="filter-btn active" data-filter="all">All Work</button>
                <button class="filter-btn" data-filter="pamphlets">Pamphlet Designs</button>
                <button class="filter-btn" data-filter="events">Event Welcome Signs</button>
                <button class="filter-btn" data-filter="promotions">Restaurant & School</button>
                <button class="filter-btn" data-filter="brands">Brand Posters</button>
            </div>
        </div>
    </section>

    <!-- Portfolio Gallery -->
    <section class="portfolio-gallery">
        <div class="container">
            <div class="gallery-grid" id="gallery-grid">
                <?php if (!empty($portfolio_items)): ?>
                    <?php foreach($portfolio_items as $item): ?>
                        <div class="gallery-item" data-category="<?php echo htmlspecialchars($item['category']); ?>">
                            <div class="gallery-image">
                                <?php if ($item['image_path']): ?>
                                    <img src="<?php echo htmlspecialchars($item['image_path']); ?>" alt="<?php echo htmlspecialchars($item['title']); ?>" style="width: 100%; height: 300px; object-fit: cover;">
                                <?php else: ?>
                                    <div class="image-placeholder <?php echo htmlspecialchars($item['category']); ?>-design">
                                        <div class="placeholder-content">
                                            <h3><?php echo safeOutputWithDecode($item['title']); ?></h3>
                                            <p><?php echo safeOutputWithDecode($item['description']); ?></p>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="gallery-overlay">
                                    <div class="overlay-content">
                        <h3><?php echo safeOutputWithDecode($item['title']); ?></h3>
                        <p><?php echo getCategoryDisplayName($item['category']); ?></p>
                        <button class="view-btn" onclick="openLightbox('<?php echo htmlspecialchars($item['category']); ?>', '<?php echo safeOutputWithDecode($item['title']); ?>', '<?php echo safeOutputWithDecode($item['description']); ?>')">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="2"/>
                                                <path d="M2.458 12C3.732 7.943 7.523 5 12 5C16.478 5 20.268 7.943 21.542 12C20.268 16.057 16.478 19 12 19C7.523 19 3.732 16.057 2.458 12Z" stroke="currentColor" stroke-width="2"/>
                                            </svg>
                                            View Details
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <!-- Default portfolio items if none in database -->
                    <div class="gallery-item" data-category="pamphlets">
                        <div class="gallery-image">
                            <div class="image-placeholder pamphlet-design">
                                <div class="placeholder-content">
                                    <h3>LIC Life Insurance</h3>
                                    <p>Advertisement Campaign</p>
                                    <div class="design-elements">
                                        <div class="element element-1"></div>
                                        <div class="element element-2"></div>
                                        <div class="element element-3"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="gallery-overlay">
                                <div class="overlay-content">
                                    <h3>LIC Advertisement</h3>
                                    <p>Pamphlet Design</p>
                                    <button class="view-btn" onclick="openLightbox('pamphlets', 'LIC Advertisement', 'Professional pamphlet design for LIC life insurance campaign featuring clean typography and compelling visuals.')">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="2"/>
                                            <path d="M2.458 12C3.732 7.943 7.523 5 12 5C16.478 5 20.268 7.943 21.542 12C20.268 16.057 16.478 19 12 19C7.523 19 3.732 16.057 2.458 12Z" stroke="currentColor" stroke-width="2"/>
                                        </svg>
                                        View Details
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="gallery-item" data-category="pamphlets">
                        <div class="gallery-image">
                            <div class="image-placeholder pamphlet-design">
                                <div class="placeholder-content">
                                    <h3>Insurance Benefits</h3>
                                    <p>Informational Brochure</p>
                                    <div class="design-elements">
                                        <div class="element element-4"></div>
                                        <div class="element element-5"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="gallery-overlay">
                                <div class="overlay-content">
                                    <h3>Insurance Benefits Brochure</h3>
                                    <p>Pamphlet Design</p>
                                    <button class="view-btn" onclick="openLightbox('pamphlets', 'Insurance Benefits Brochure', 'Informational brochure highlighting key insurance benefits with clear infographics and professional layout.')">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="2"/>
                                            <path d="M2.458 12C3.732 7.943 7.523 5 12 5C16.478 5 20.268 7.943 21.542 12C20.268 16.057 16.478 19 12 19C7.523 19 3.732 16.057 2.458 12Z" stroke="currentColor" stroke-width="2"/>
                                        </svg>
                                        View Details
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Event Welcome Signs -->
                    <div class="gallery-item" data-category="events">
                        <div class="gallery-image">
                            <div class="image-placeholder event-design">
                                <div class="placeholder-content">
                                    <h3>Welcome to</h3>
                                    <h2>Manik & Yamini</h2>
                                    <p>Wedding Celebration</p>
                                    <div class="decorative-elements">
                                        <div class="flower flower-1">🌸</div>
                                        <div class="flower flower-2">🌺</div>
                                        <div class="flower flower-3">🌸</div>
                                    </div>
                                </div>
                            </div>
                            <div class="gallery-overlay">
                                <div class="overlay-content">
                                    <h3>Manik & Yamini Wedding</h3>
                                    <p>Welcome Board Design</p>
                                    <button class="view-btn" onclick="openLightbox('events', 'Manik & Yamini Wedding Welcome', 'Elegant wedding welcome board featuring beautiful typography and floral elements for a memorable celebration.')">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="2"/>
                                            <path d="M2.458 12C3.732 7.943 7.523 5 12 5C16.478 5 20.268 7.943 21.542 12C20.268 16.057 16.478 19 12 19C7.523 19 3.732 16.057 2.458 12Z" stroke="currentColor" stroke-width="2"/>
                                        </svg>
                                        View Details
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="gallery-item" data-category="events">
                        <div class="gallery-image">
                            <div class="image-placeholder event-design">
                                <div class="placeholder-content">
                                    <h3>Celebrating</h3>
                                    <h2>Love & Unity</h2>
                                    <p>Wedding Welcome</p>
                                    <div class="decorative-elements">
                                        <div class="heart">💕</div>
                                        <div class="rings">💍</div>
                                    </div>
                                </div>
                            </div>
                            <div class="gallery-overlay">
                                <div class="overlay-content">
                                    <h3>Love & Unity Wedding</h3>
                                    <p>Welcome Board Design</p>
                                    <button class="view-btn" onclick="openLightbox('events', 'Love & Unity Wedding Welcome', 'Romantic wedding welcome board with elegant script typography and symbolic design elements.')">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="2"/>
                                            <path d="M2.458 12C3.732 7.943 7.523 5 12 5C16.478 5 20.268 7.943 21.542 12C20.268 16.057 16.478 19 12 19C7.523 19 3.732 16.057 2.458 12Z" stroke="currentColor" stroke-width="2"/>
                                        </svg>
                                        View Details
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Restaurant & School Promotions -->
                    <div class="gallery-item" data-category="promotions">
                        <div class="gallery-image">
                            <div class="image-placeholder promotion-design">
                                <div class="placeholder-content">
                                    <h3>Singla's Restaurant</h3>
                                    <p>Authentic Indian Cuisine</p>
                                    <div class="food-elements">
                                        <div class="food-icon">🍛</div>
                                        <div class="food-icon">🥘</div>
                                        <div class="food-icon">🍜</div>
                                    </div>
                                    <div class="promo-badge">Special Offer</div>
                                </div>
                            </div>
                            <div class="gallery-overlay">
                                <div class="overlay-content">
                                    <h3>Singla's Restaurant Brochure</h3>
                                    <p>Restaurant Promotion</p>
                                    <button class="view-btn" onclick="openLightbox('promotions', 'Singlas Restaurant Brochure', 'Appetizing restaurant brochure design featuring menu highlights and special offers with vibrant food photography.')">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="2"/>
                                            <path d="M2.458 12C3.732 7.943 7.523 5 12 5C16.478 5 20.268 7.943 21.542 12C20.268 16.057 16.478 19 12 19C7.523 19 3.732 16.057 2.458 12Z" stroke="currentColor" stroke-width="2"/>
                                        </svg>
                                        View Details
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="gallery-item" data-category="promotions">
                        <div class="gallery-image">
                            <div class="image-placeholder promotion-design">
                                <div class="placeholder-content">
                                    <h3>Maharana Pratap</h3>
                                    <h2>Public School</h2>
                                    <p>Excellence in Education</p>
                                    <div class="school-elements">
                                        <div class="school-icon">📚</div>
                                        <div class="school-icon">🎓</div>
                                        <div class="school-icon">✏️</div>
                                    </div>
                                </div>
                            </div>
                            <div class="gallery-overlay">
                                <div class="overlay-content">
                                    <h3>Maharana Pratap School</h3>
                                    <p>School Promotion</p>
                                    <button class="view-btn" onclick="openLightbox('promotions', 'Maharana Pratap School Brochure', 'Educational institution brochure highlighting academic excellence and school facilities with professional design.')">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="2"/>
                                            <path d="M2.458 12C3.732 7.943 7.523 5 12 5C16.478 5 20.268 7.943 21.542 12C20.268 16.057 16.478 19 12 19C7.523 19 3.732 16.057 2.458 12Z" stroke="currentColor" stroke-width="2"/>
                                        </svg>
                                        View Details
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Brand Posters -->
                    <div class="gallery-item" data-category="brands">
                        <div class="gallery-image">
                            <div class="image-placeholder brand-design">
                                <div class="placeholder-content">
                                    <h3>OKAYA</h3>
                                    <h2>Electric Scooters</h2>
                                    <p>Ride the Future</p>
                                    <div class="brand-elements">
                                        <div class="scooter-icon">🛵</div>
                                        <div class="electric-icon">⚡</div>
                                        <div class="eco-icon">🌱</div>
                                    </div>
                                </div>
                            </div>
                            <div class="gallery-overlay">
                                <div class="overlay-content">
                                    <h3>Okaya Electric Scooters</h3>
                                    <p>Brand Poster</p>
                                    <button class="view-btn" onclick="openLightbox('brands', 'Okaya Electric Scooters Poster', 'Dynamic brand poster for electric scooters emphasizing eco-friendly transportation with modern design elements.')">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="2"/>
                                            <path d="M2.458 12C3.732 7.943 7.523 5 12 5C16.478 5 20.268 7.943 21.542 12C20.268 16.057 16.478 19 12 19C7.523 19 3.732 16.057 2.458 12Z" stroke="currentColor" stroke-width="2"/>
                                        </svg>
                                        View Details
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="gallery-item" data-category="brands">
                        <div class="gallery-image">
                            <div class="image-placeholder brand-design">
                                <div class="placeholder-content">
                                    <h3>KINETICS FIT</h3>
                                    <h2>Unisex Gym</h2>
                                    <p>Transform Your Body</p>
                                    <div class="brand-elements">
                                        <div class="gym-icon">💪</div>
                                        <div class="fitness-icon">🏋️</div>
                                        <div class="health-icon">❤️</div>
                                    </div>
                                </div>
                            </div>
                            <div class="gallery-overlay">
                                <div class="overlay-content">
                                    <h3>Kinetics Fit Gym</h3>
                                    <p>Brand Poster</p>
                                    <button class="view-btn" onclick="openLightbox('brands', 'Kinetics Fit Gym Poster', 'Energetic gym poster design promoting fitness and health with bold typography and motivational messaging.')">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="2"/>
                                            <path d="M2.458 12C3.732 7.943 7.523 5 12 5C16.478 5 20.268 7.943 21.542 12C20.268 16.057 16.478 19 12 19C7.523 19 3.732 16.057 2.458 12Z" stroke="currentColor" stroke-width="2"/>
                                        </svg>
                                        View Details
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Lightbox Modal -->
    <div class="lightbox" id="lightbox">
        <div class="lightbox-overlay" onclick="closeLightbox()"></div>
        <div class="lightbox-content">
            <button class="lightbox-close" onclick="closeLightbox()">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M18 6L6 18M6 6L18 18" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                </svg>
            </button>
            <div class="lightbox-image">
                <div class="lightbox-placeholder" id="lightbox-image">
                    <!-- Dynamic content will be inserted here -->
                </div>
            </div>
            <div class="lightbox-info">
                <h3 id="lightbox-title">Project Title</h3>
                <p class="lightbox-category" id="lightbox-category">Category</p>
                <p class="lightbox-description" id="lightbox-description">Project description</p>
                <div class="lightbox-details">
                    <div class="detail-item">
                        <strong>Client:</strong> <span id="lightbox-client">Various</span>
                    </div>
                    <div class="detail-item">
                        <strong>Year:</strong> <span id="lightbox-year">2023</span>
                    </div>
                    <div class="detail-item">
                        <strong>Tools:</strong> <span id="lightbox-tools">Adobe Photoshop, Illustrator</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Call to Action -->
    <section class="portfolio-cta">
        <div class="container">
            <div class="cta-content">
                <h2>Like What You See?</h2>
                <p>
                    Let's discuss your next project and create something amazing together. 
                    I'm always excited to take on new challenges and bring creative visions to life.
                </p>
                <div class="cta-buttons">
                    <a href="contact.php" class="btn btn-primary">Start a Project</a>
                    <a href="about.php" class="btn btn-secondary">Learn More About Me</a>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <!-- Footer Background Graphics -->
        <div class="footer-background-graphics">
            <div class="footer-pattern-1"></div>
            <div class="footer-pattern-2"></div>
            <div class="footer-decorative-elements">
                <div class="footer-shape footer-shape-1">
                    <svg width="120" height="120" viewBox="0 0 120 120" fill="none">
                        <circle cx="60" cy="60" r="60" fill="url(#footerGrad1)" opacity="0.1"/>
                        <circle cx="60" cy="60" r="40" fill="url(#footerGrad2)" opacity="0.15"/>
                        <circle cx="60" cy="60" r="20" fill="url(#footerGrad3)" opacity="0.2"/>
                        <defs>
                            <radialGradient id="footerGrad1" cx="50%" cy="50%" r="50%">
                                <stop offset="0%" style="stop-color:#E8B4CB;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#8B5A96;stop-opacity:0" />
                            </radialGradient>
                            <radialGradient id="footerGrad2" cx="50%" cy="50%" r="50%">
                                <stop offset="0%" style="stop-color:#D4A574;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#E8B4CB;stop-opacity:0" />
                            </radialGradient>
                            <radialGradient id="footerGrad3" cx="50%" cy="50%" r="50%">
                                <stop offset="0%" style="stop-color:#8B5A96;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#D4A574;stop-opacity:0" />
                            </radialGradient>
                        </defs>
                    </svg>
                </div>
                <div class="footer-shape footer-shape-2">
                    <svg width="80" height="80" viewBox="0 0 80 80" fill="none">
                        <path d="M40 0L50 30L80 40L50 50L40 80L30 50L0 40L30 30L40 0Z" fill="url(#footerStarGrad)" opacity="0.12"/>
                        <defs>
                            <linearGradient id="footerStarGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" style="stop-color:#E8B4CB;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#D4A574;stop-opacity:1" />
                            </linearGradient>
                        </defs>
                    </svg>
                </div>
                <div class="footer-shape footer-shape-3">
                    <svg width="100" height="100" viewBox="0 0 100 100" fill="none">
                        <polygon points="50,5 65,35 95,35 73,57 80,87 50,70 20,87 27,57 5,35 35,35" fill="url(#footerPolygonGrad)" opacity="0.08"/>
                        <defs>
                            <linearGradient id="footerPolygonGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" style="stop-color:#8B5A96;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#E8B4CB;stop-opacity:1" />
                            </linearGradient>
                        </defs>
                    </svg>
                </div>
                <div class="footer-shape footer-shape-4">
                    <svg width="60" height="60" viewBox="0 0 60 60" fill="none">
                        <rect x="15" y="15" width="30" height="30" rx="8" fill="url(#footerRectGrad)" opacity="0.15" transform="rotate(45 30 30)"/>
                        <defs>
                            <linearGradient id="footerRectGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" style="stop-color:#D4A574;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#8B5A96;stop-opacity:1" />
                            </linearGradient>
                        </defs>
                    </svg>
                </div>
            </div>
        </div>

        <div class="container">
            <div class="footer-content">
                <div class="footer-info">
                    <div class="footer-logo">
                        <svg width="40" height="40" viewBox="0 0 40 40" fill="none" class="footer-logo-icon">
