<?php
require_once 'includes/site_data.php';
require_once 'includes/portfolio_data.php';

// Get dynamic content
$about_data = getAboutData();
$contact_info = getContactInfo();
$featured_portfolio = getPortfolioItems(null, true, 4);
$site_title = getSiteSetting('site_title', 'Manisha - Graphic Designer');
$hero_title = getSiteSetting('hero_title', 'Hi, I\'m Manisha');
$hero_subtitle = getSiteSetting('hero_subtitle', 'Graphic Designer');
$newsletter_text = getSiteSetting('newsletter_text', 'Get design tips and project updates');
$footer_copyright = getSiteSetting('footer_copyright', '© 2024 Manisha. All rights reserved.');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($site_title); ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Playfair+Display:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/responsive.css">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar" id="navbar">
        <div class="nav-container">
            <div class="nav-logo">
                <a href="index.php"><?php echo htmlspecialchars($about_data['name'] ?? 'Manisha'); ?></a>
            </div>
            <div class="nav-menu" id="nav-menu">
                <a href="index.php" class="nav-link active">Home</a>
                <a href="about.php" class="nav-link">About</a>
                <a href="portfolio.php" class="nav-link">Portfolio</a>
                <a href="contact.php" class="nav-link">Contact</a>
            </div>
            <div class="hamburger" id="hamburger">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero" id="home">
        <div class="hero-background-pattern"></div>
        <div class="hero-decorative-elements">
            <div class="floating-shape shape-1">
                <svg width="60" height="60" viewBox="0 0 60 60" fill="none">
                    <path d="M30 0L37.32 22.68L60 30L37.32 37.32L30 60L22.68 37.32L0 30L22.68 22.68L30 0Z" fill="url(#starGrad1)"/>
                    <defs>
                        <linearGradient id="starGrad1" x1="0%" y1="0%" x2="100%" y2="100%">
                            <stop offset="0%" style="stop-color:#E8B4CB;stop-opacity:0.3" />
                            <stop offset="100%" style="stop-color:#8B5A96;stop-opacity:0.1" />
                        </linearGradient>
                    </defs>
                </svg>
            </div>
            <div class="floating-shape shape-2">
                <svg width="40" height="40" viewBox="0 0 40 40" fill="none">
                    <circle cx="20" cy="20" r="20" fill="url(#circleGrad1)"/>
                    <defs>
                        <radialGradient id="circleGrad1" cx="50%" cy="50%" r="50%">
                            <stop offset="0%" style="stop-color:#D4A574;stop-opacity:0.4" />
                            <stop offset="100%" style="stop-color:#8B5A96;stop-opacity:0.1" />
                        </radialGradient>
                    </defs>
                </svg>
            </div>
            <div class="floating-shape shape-3">
                <svg width="80" height="80" viewBox="0 0 80 80" fill="none">
                    <polygon points="40,10 60,30 40,50 20,30" fill="url(#diamondGrad1)"/>
                    <defs>
                        <linearGradient id="diamondGrad1" x1="0%" y1="0%" x2="100%" y2="100%">
                            <stop offset="0%" style="stop-color:#E8B4CB;stop-opacity:0.2" />
                            <stop offset="100%" style="stop-color:#D4A574;stop-opacity:0.1" />
                        </linearGradient>
                    </defs>
                </svg>
            </div>
            <div class="floating-shape shape-4">
                <svg width="50" height="50" viewBox="0 0 50 50" fill="none">
                    <rect x="10" y="10" width="30" height="30" rx="5" fill="url(#rectGrad1)" transform="rotate(45 25 25)"/>
                    <defs>
                        <linearGradient id="rectGrad1" x1="0%" y1="0%" x2="100%" y2="100%">
                            <stop offset="0%" style="stop-color:#8B5A96;stop-opacity:0.3" />
                            <stop offset="100%" style="stop-color:#E8B4CB;stop-opacity:0.1" />
                        </linearGradient>
                    </defs>
                </svg>
            </div>
            <div class="floating-shape shape-5">
                <svg width="35" height="35" viewBox="0 0 35 35" fill="none">
                    <path d="M17.5 0L21.5 13.5L35 17.5L21.5 21.5L17.5 35L13.5 21.5L0 17.5L13.5 13.5L17.5 0Z" fill="url(#starGrad2)"/>
                    <defs>
                        <linearGradient id="starGrad2" x1="0%" y1="0%" x2="100%" y2="100%">
                            <stop offset="0%" style="stop-color:#D4A574;stop-opacity:0.4" />
                            <stop offset="100%" style="stop-color:#8B5A96;stop-opacity:0.2" />
                        </linearGradient>
                    </defs>
                </svg>
            </div>
        </div>
        <div class="hero-container">
            <div class="hero-content" data-aos="fade-up" data-aos-duration="1000">
                <h1 class="hero-title">
                    <?php echo safeOutputWithDecode($hero_title); ?>
                </h1>
                <h2 class="hero-subtitle"><?php echo safeOutputWithDecode($hero_subtitle); ?></h2>
                <p class="hero-description">
                    <?php echo safeOutputWithDecode($about_data['hero_description'] ?? 'Passionate about advertising, brand design, and print design. Creating sleek and polished visual experiences that make an impact.'); ?>
                </p>
                <div class="hero-buttons">
                    <a href="portfolio.php" class="btn btn-primary">View My Work</a>
                    <a href="contact.php" class="btn btn-secondary">Get In Touch</a>
                </div>
            </div>
            <div class="hero-image" data-aos="fade-left" data-aos-duration="1000" data-aos-delay="300">
                <div class="image-placeholder">
                    <?php if ($about_data && $about_data['profile_image']): ?>
                        <img src="<?php echo htmlspecialchars($about_data['profile_image']); ?>" alt="<?php echo htmlspecialchars($about_data['name']); ?>" style="width: 350px; height: 350px; object-fit: cover; border-radius: 50%;">
                    <?php else: ?>
                        <svg width="350" height="350" viewBox="0 0 350 350" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <defs>
                                <linearGradient id="grad1" x1="0%" y1="0%" x2="100%" y2="100%">
                                    <stop offset="0%" style="stop-color:#8B5A96;stop-opacity:1" />
                                    <stop offset="100%" style="stop-color:#D4A574;stop-opacity:1" />
                                </linearGradient>
                                <linearGradient id="grad2" x1="0%" y1="0%" x2="100%" y2="100%">
                                    <stop offset="0%" style="stop-color:#E8B4CB;stop-opacity:1" />
                                    <stop offset="100%" style="stop-color:#8B5A96;stop-opacity:1" />
                                </linearGradient>
                            </defs>
                            <circle cx="175" cy="175" r="175" fill="url(#grad1)" opacity="0.1"/>
                            <circle cx="175" cy="140" r="50" fill="url(#grad2)"/>
                            <path d="M120 230 Q175 180 230 230 Q230 260 175 280 Q120 260 120 230" fill="url(#grad2)"/>
                            <circle cx="155" cy="125" r="8" fill="#FAF0E6"/>
                            <circle cx="195" cy="125" r="8" fill="#FAF0E6"/>
                            <path d="M160 160 Q175 175 190 160" stroke="#FAF0E6" stroke-width="3" fill="none"/>
                        </svg>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

    <!-- About Preview Section -->
    <section class="about-preview">
        <div class="container">
            <div class="section-header" data-aos="fade-up" data-aos-duration="800">
                <h2>About Me</h2>
                <p>Get to know the designer behind the work</p>
            </div>
            <div class="about-content">
                <div class="about-text" data-aos="fade-right" data-aos-duration="800" data-aos-delay="200">
                    <p>
                        <?php echo htmlspecialchars($about_data['bio'] ?? 'I feel very connected to advertising. I am passionate about brand design and print design. My goal is to make my mark in digital media and tech spaces.'); ?>
                    </p>
                    <a href="about.php" class="btn btn-outline">Learn More</a>
                </div>
                <div class="about-stats" data-aos="fade-left" data-aos-duration="800" data-aos-delay="400">
                    <div class="stat" data-aos="zoom-in" data-aos-duration="600" data-aos-delay="600">
                        <h3><?php echo $about_data['projects_completed'] ?? 50; ?>+</h3>
                        <p>Projects Completed</p>
                    </div>
                    <div class="stat" data-aos="zoom-in" data-aos-duration="600" data-aos-delay="700">
                        <h3><?php echo $about_data['years_experience'] ?? 3; ?>+</h3>
                        <p>Years Experience</p>
                    </div>
                    <div class="stat" data-aos="zoom-in" data-aos-duration="600" data-aos-delay="800">
                        <h3><?php echo $about_data['happy_clients'] ?? 25; ?>+</h3>
                        <p>Happy Clients</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Portfolio Preview Section -->
    <section class="portfolio-preview">
        <div class="container">
            <div class="section-header" data-aos="fade-up" data-aos-duration="800">
                <h2>Featured Work</h2>
                <p>A glimpse into my creative journey</p>
            </div>
            <div class="portfolio-grid">
                <?php if (!empty($featured_portfolio)): ?>
                    <?php foreach($featured_portfolio as $index => $item): ?>
                        <div class="portfolio-item" data-category="<?php echo htmlspecialchars($item['category']); ?>" data-aos="fade-up" data-aos-duration="600" data-aos-delay="<?php echo ($index + 1) * 100; ?>">
                            <div class="portfolio-image">
                                <?php if ($item['image_path']): ?>
                                    <img src="<?php echo htmlspecialchars($item['image_path']); ?>" alt="<?php echo htmlspecialchars($item['title']); ?>" style="width: 100%; height: 250px; object-fit: cover;">
                                <?php else: ?>
                                    <div class="image-placeholder">
                                        <span><?php echo htmlspecialchars($item['title']); ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="portfolio-info">
                                <h3><?php echo getCategoryDisplayName($item['category']); ?></h3>
                                <p><?php echo htmlspecialchars($item['title']); ?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <!-- Default portfolio items if none in database -->
                    <div class="portfolio-item" data-category="pamphlets" data-aos="fade-up" data-aos-duration="600" data-aos-delay="100">
                        <div class="portfolio-image">
                            <div class="image-placeholder">
                                <span>LIC Advertisement</span>
                            </div>
                        </div>
                        <div class="portfolio-info">
                            <h3>Pamphlet Designs</h3>
                            <p>LIC Advertisements</p>
                        </div>
                    </div>
                    <div class="portfolio-item" data-category="events" data-aos="fade-up" data-aos-duration="600" data-aos-delay="200">
                        <div class="portfolio-image">
                            <div class="image-placeholder">
                                <span>Wedding Welcome</span>
                            </div>
                        </div>
                        <div class="portfolio-info">
                            <h3>Event Welcome Signs</h3>
                            <p>Wedding Welcome Boards</p>
                        </div>
                    </div>
                    <div class="portfolio-item" data-category="promotions" data-aos="fade-up" data-aos-duration="600" data-aos-delay="300">
                        <div class="portfolio-image">
                            <div class="image-placeholder">
                                <span>Restaurant Brochure</span>
                            </div>
                        </div>
                        <div class="portfolio-info">
                            <h3>Restaurant Promotions</h3>
                            <p>Singla's Brochures</p>
                        </div>
                    </div>
                    <div class="portfolio-item" data-category="brands" data-aos="fade-up" data-aos-duration="600" data-aos-delay="400">
                        <div class="portfolio-image">
                            <div class="image-placeholder">
                                <span>Brand Poster</span>
                            </div>
                        </div>
                        <div class="portfolio-info">
                            <h3>Brand Posters</h3>
                            <p>Okaya Electric Scooters</p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="portfolio-cta" data-aos="fade-up" data-aos-duration="600" data-aos-delay="500">
                <a href="portfolio.php" class="btn btn-primary">View All Work</a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <!-- Footer Background Graphics -->
        <div class="footer-background-graphics">
            <div class="footer-pattern-1"></div>
            <div class="footer-pattern-2"></div>
            <div class="footer-decorative-elements">
                <div class="footer-shape footer-shape-1">
                    <svg width="120" height="120" viewBox="0 0 120 120" fill="none">
                        <circle cx="60" cy="60" r="60" fill="url(#footerGrad1)" opacity="0.1"/>
                        <circle cx="60" cy="60" r="40" fill="url(#footerGrad2)" opacity="0.15"/>
                        <circle cx="60" cy="60" r="20" fill="url(#footerGrad3)" opacity="0.2"/>
                        <defs>
                            <radialGradient id="footerGrad1" cx="50%" cy="50%" r="50%">
                                <stop offset="0%" style="stop-color:#E8B4CB;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#8B5A96;stop-opacity:0" />
                            </radialGradient>
                            <radialGradient id="footerGrad2" cx="50%" cy="50%" r="50%">
                                <stop offset="0%" style="stop-color:#D4A574;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#E8B4CB;stop-opacity:0" />
                            </radialGradient>
                            <radialGradient id="footerGrad3" cx="50%" cy="50%" r="50%">
                                <stop offset="0%" style="stop-color:#8B5A96;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#D4A574;stop-opacity:0" />
                            </radialGradient>
                        </defs>
                    </svg>
                </div>
                <div class="footer-shape footer-shape-2">
                    <svg width="80" height="80" viewBox="0 0 80 80" fill="none">
                        <path d="M40 0L50 30L80 40L50 50L40 80L30 50L0 40L30 30L40 0Z" fill="url(#footerStarGrad)" opacity="0.12"/>
                        <defs>
                            <linearGradient id="footerStarGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" style="stop-color:#E8B4CB;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#D4A574;stop-opacity:1" />
                            </linearGradient>
                        </defs>
                    </svg>
                </div>
                <div class="footer-shape footer-shape-3">
                    <svg width="100" height="100" viewBox="0 0 100 100" fill="none">
                        <polygon points="50,5 65,35 95,35 73,57 80,87 50,70 20,87 27,57 5,35 35,35" fill="url(#footerPolygonGrad)" opacity="0.08"/>
                        <defs>
                            <linearGradient id="footerPolygonGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" style="stop-color:#8B5A96;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#E8B4CB;stop-opacity:1" />
                            </linearGradient>
                        </defs>
                    </svg>
                </div>
                <div class="footer-shape footer-shape-4">
                    <svg width="60" height="60" viewBox="0 0 60 60" fill="none">
                        <rect x="15" y="15" width="30" height="30" rx="8" fill="url(#footerRectGrad)" opacity="0.15" transform="rotate(45 30 30)"/>
                        <defs>
                            <linearGradient id="footerRectGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" style="stop-color:#D4A574;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#8B5A96;stop-opacity:1" />
                            </linearGradient>
                        </defs>
                    </svg>
                </div>
            </div>
        </div>

        <div class="container">
            <div class="footer-content">
                <div class="footer-info">
                    <div class="footer-logo">
                        <svg width="40" height="40" viewBox="0 0 40 40" fill="none" class="footer-logo-icon">
                            <circle cx="20" cy="20" r="20" fill="url(#logoGrad)"/>
                            <path d="M12 15 L20 25 L28 15" stroke="white" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round"/>
                            <circle cx="20" cy="12" r="3" fill="white"/>
                            <defs>
                                <linearGradient id="logoGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                    <stop offset="0%" style="stop-color:#E8B4CB;stop-opacity:1" />
                                    <stop offset="100%" style="stop-color:#8B5A96;stop-opacity:1" />
                                </linearGradient>
                            </defs>
                        </svg>
                        <h3><?php echo htmlspecialchars($about_data['name'] ?? 'Manisha'); ?></h3>
                    </div>
                    <p>Graphic Designer passionate about creating impactful visual experiences that tell compelling stories and connect with audiences.</p>
                    <div class="footer-contact-info">
                        <div class="contact-item">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/>
                            </svg>
                            <span><?php echo htmlspecialchars($contact_info['email'] ?? 'manisha.designer@email.com'); ?></span>
                        </div>
                        <div class="contact-item">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
                            </svg>
                            <span><?php echo htmlspecialchars($contact_info['location'] ?? 'India'); ?></span>
                        </div>
                    </div>
                </div>
                <div class="footer-links">
                    <h4>Quick Links</h4>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="about.php">About</a></li>
                        <li><a href="portfolio.php">Portfolio</a></li>
                        <li><a href="contact.php">Contact</a></li>
                    </ul>
                </div>
                <div class="footer-services">
                    <h4>Services</h4>
                    <ul>
                        <li>Brand Design</li>
                        <li>Print Design</li>
                        <li>Advertising Campaigns</li>
                        <li>Event Design</li>
                    </ul>
                </div>
                <div class="footer-social">
                    <h4>Follow Me</h4>
                    <div class="social-links">
                        <?php if ($contact_info['instagram_url']): ?>
                            <a href="<?php echo htmlspecialchars($contact_info['instagram_url']); ?>" class="social-link instagram">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                        <?php if ($contact_info['behance_url']): ?>
                            <a href="<?php echo htmlspecialchars($contact_info['behance_url']); ?>" class="social-link behance">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M6.938 4.503c.702 0 1.34.06 1.92.188.577.13 1.07.33 1.485.61.41.28.733.65.96 1.12.225.47.34 1.05.34 1.73 0 .74-.17 1.36-.507 1.86-.338.5-.837.9-1.502 1.22.906.26 1.576.72 2.022 1.37.448.66.665 1.45.665 2.36 0 .75-.13 1.39-.41 1.93-.28.55-.67 1-1.16 1.35-.48.348-1.05.6-1.67.76-.62.16-1.25.24-1.89.24H0V4.51h6.938v-.007zM3.495 8.42h2.876c.606 0 1.1-.15 1.48-.45.38-.3.57-.75.57-1.35 0-.28-.06-.51-.18-.69-.12-.18-.29-.32-.51-.42-.21-.1-.46-.17-.75-.21-.29-.04-.61-.06-.94-.06H3.495v3.18zm0 7.17h3.62c.35 0 .67-.04.96-.1.29-.07.54-.17.75-.3.21-.13.37-.3.48-.52.11-.22.17-.48.17-.78 0-.68-.23-1.15-.69-1.4-.46-.25-1.08-.38-1.85-.38H3.495v3.48z"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                        <?php if ($contact_info['linkedin_url']): ?>
                            <a href="<?php echo htmlspecialchars($contact_info['linkedin_url']); ?>" class="social-link linkedin">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                        <?php if ($contact_info['dribbble_url']): ?>
                            <a href="<?php echo htmlspecialchars($contact_info['dribbble_url']); ?>" class="social-link dribbble">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 0C5.374 0 0 5.374 0 12s5.374 12 12 12 12-5.374 12-12S18.626 0 12 0zm7.568 5.302c1.4 1.5 2.252 3.5 2.273 5.698-.653-.126-1.542-.224-2.402-.224-.2 0-.402.002-.604.006-.024-.593-.094-1.164-.194-1.702 1.084-.497 1.736-.78 1.927-.778zm-1.927.778c-.191-.002-.843.281-1.927.778-.1.538-.17 1.109-.194 1.702-.202-.004-.404-.006-.604-.006-.86 0-1.749.098-2.402.224.021-2.198.873-4.198 2.273-5.698 1.5 1.4 2.252 3.5 2.273 5.698-.653-.126-1.542-.224-2.402-.224-.2 0-.402.002-.604.006-.024-.593-.094-1.164-.194-1.702z"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                    </div>
                    <div class="footer-newsletter">
                        <h5>Stay Updated</h5>
                        <p><?php echo htmlspecialchars($newsletter_text); ?></p>
                        <form class="newsletter-form" id="newsletter-form">
                            <input type="email" name="email" placeholder="Enter your email" class="newsletter-input" required>
                            <button type="submit" class="newsletter-btn">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M2.01 21L23 12 2.01 3 2 10l15 2-15 2z"/>
                                </svg>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <div class="footer-bottom-content">
                    <p><?php echo htmlspecialchars($footer_copyright); ?></p>
                    <div class="footer-bottom-links">
                        <a href="#">Privacy Policy</a>
                        <a href="#">Terms of Service</a>
                        <a href="#">Cookies</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="js/main.js"></script>
    <script>
        AOS.init({
            duration: 800,
            easing: 'ease-in-out',
            once: true,
            offset: 100
        });

        // Newsletter form submission
        document.getElementById('newsletter-form').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            const button = this.querySelector('.newsletter-btn');
            const input = this.querySelector('.newsletter-input');
            
            button.disabled = true;
            
            fetch('api/newsletter.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    input.value = '';
                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(error => {
                alert('An error occurred. Please try again.');
            })
            .finally(() => {
                button.disabled = false;
            });
        });
    </script>
</body>
</html>
