-- Portfolio Website Database Schema
-- Run this SQL script to create the database and tables

CREATE DATABASE IF NOT EXISTS portfolio_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE portfolio_db;

-- Users table for admin authentication
CREATE TABLE users (
    id INT PRIMARY KEY AUTO_INCREMENT,
    username VARCHAR(50) UNIQUE NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Site settings table
CREATE TABLE site_settings (
    id INT PRIMARY KEY AUTO_INCREMENT,
    setting_key VARCHAR(100) UNIQUE NOT NULL,
    setting_value TEXT,
    setting_type ENUM('text', 'textarea', 'image', 'url', 'number') DEFAULT 'text',
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- About section content
CREATE TABLE about_section (
    id INT PRIMARY KEY AUTO_INCREMENT,
    name VARCHAR(100) NOT NULL,
    title VARCHAR(100) NOT NULL,
    bio TEXT NOT NULL,
    profile_image VARCHAR(255),
    hero_description TEXT,
    story_content TEXT,
    years_experience INT DEFAULT 0,
    projects_completed INT DEFAULT 0,
    happy_clients INT DEFAULT 0,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Skills table
CREATE TABLE skills (
    id INT PRIMARY KEY AUTO_INCREMENT,
    category VARCHAR(100) NOT NULL,
    skill_name VARCHAR(100) NOT NULL,
    skill_level INT DEFAULT 0,
    display_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Experience timeline
CREATE TABLE experience (
    id INT PRIMARY KEY AUTO_INCREMENT,
    job_title VARCHAR(150) NOT NULL,
    company VARCHAR(150),
    start_date DATE,
    end_date DATE,
    is_current BOOLEAN DEFAULT FALSE,
    description TEXT,
    achievements TEXT,
    display_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Portfolio items
CREATE TABLE portfolio_items (
    id INT PRIMARY KEY AUTO_INCREMENT,
    title VARCHAR(200) NOT NULL,
    description TEXT,
    category VARCHAR(100) NOT NULL,
    client VARCHAR(100),
    year YEAR,
    tools_used VARCHAR(255),
    image_path VARCHAR(255),
    is_featured BOOLEAN DEFAULT FALSE,
    display_order INT DEFAULT 0,
    status ENUM('active', 'inactive') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Contact information
CREATE TABLE contact_info (
    id INT PRIMARY KEY AUTO_INCREMENT,
    email VARCHAR(100) NOT NULL,
    phone VARCHAR(20),
    location VARCHAR(100),
    address TEXT,
    instagram_url VARCHAR(255),
    behance_url VARCHAR(255),
    linkedin_url VARCHAR(255),
    dribbble_url VARCHAR(255),
    other_social_links JSON,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Newsletter subscribers
CREATE TABLE newsletter_subscribers (
    id INT PRIMARY KEY AUTO_INCREMENT,
    email VARCHAR(100) UNIQUE NOT NULL,
    status ENUM('active', 'inactive', 'unsubscribed') DEFAULT 'active',
    subscribed_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    unsubscribed_at TIMESTAMP NULL
);

-- Contact form messages
CREATE TABLE contact_messages (
    id INT PRIMARY KEY AUTO_INCREMENT,
    name VARCHAR(100) NOT NULL,
    email VARCHAR(100) NOT NULL,
    phone VARCHAR(20),
    subject VARCHAR(200) NOT NULL,
    budget VARCHAR(50),
    message TEXT NOT NULL,
    newsletter_signup BOOLEAN DEFAULT FALSE,
    status ENUM('new', 'read', 'replied', 'archived') DEFAULT 'new',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Insert default admin user (password: admin123)
INSERT INTO users (username, email, password) VALUES 
('admin', 'admin@portfolio.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi');

-- Insert default site settings
INSERT INTO site_settings (setting_key, setting_value, setting_type) VALUES
('site_title', 'Manisha - Graphic Designer', 'text'),
('site_description', 'Passionate about advertising, brand design, and print design.', 'textarea'),
('footer_copyright', '© 2024 Manisha. All rights reserved.', 'text'),
('newsletter_text', 'Get design tips and project updates', 'text'),
('hero_title', 'Hi, I\'m Manisha', 'text'),
('hero_subtitle', 'Graphic Designer', 'text');

-- Insert default about section
INSERT INTO about_section (name, title, bio, hero_description, story_content, years_experience, projects_completed, happy_clients) VALUES
('Manisha', 'Graphic Designer', 
'I feel very connected to advertising. I am passionate about brand design and print design. My goal is to make my mark in digital media and tech spaces.',
'Passionate about advertising, brand design, and print design. Creating sleek and polished visual experiences that make an impact.',
'I feel very connected to advertising. I am passionate about brand design and print design. My goal is to make my mark in digital media and tech spaces. I would love to work with people and companies who will give me an opportunity to flex my sleek and polished style.',
3, 50, 25);

-- Insert default skills
INSERT INTO skills (category, skill_name, skill_level, display_order) VALUES
('Design Software', 'Adobe Photoshop', 95, 1),
('Design Software', 'Adobe Illustrator', 90, 2),
('Design Software', 'Adobe InDesign', 85, 3),
('Design Software', 'Figma', 80, 4),
('Design Specialties', 'Brand Identity', 92, 1),
('Design Specialties', 'Print Design', 95, 2),
('Design Specialties', 'Advertising', 88, 3),
('Design Specialties', 'Layout Design', 90, 4);

-- Insert default experience
INSERT INTO experience (job_title, company, start_date, end_date, is_current, description, achievements, display_order) VALUES
('Freelance Graphic Designer', 'Self-Employed', '2022-01-01', NULL, TRUE, 
'Working with diverse clients on brand identity, advertising campaigns, and print design projects. Specialized in creating impactful visual solutions for businesses and events.',
'LIC Advertisement Campaigns, Wedding Welcome Board Designs, Restaurant & School Promotional Materials, Brand Poster Designs', 1),
('Junior Graphic Designer', 'Design Studio', '2021-01-01', '2022-12-31', FALSE,
'Gained valuable experience in a collaborative environment, working on various print and digital design projects while developing my signature sleek and polished style.',
'Brand Identity Development, Marketing Collateral Design, Client Presentation Materials', 2);

-- Insert default portfolio items
INSERT INTO portfolio_items (title, description, category, client, year, tools_used, is_featured, display_order) VALUES
('LIC Advertisement', 'Professional pamphlet design for LIC life insurance campaign featuring clean typography and compelling visuals.', 'pamphlets', 'LIC', 2023, 'Adobe Photoshop, Illustrator', TRUE, 1),
('Manik & Yamini Wedding Welcome', 'Elegant wedding welcome board featuring beautiful typography and floral elements for a memorable celebration.', 'events', 'Private Client', 2023, 'Adobe Photoshop, Illustrator', TRUE, 2),
('Singla\'s Restaurant Brochure', 'Appetizing restaurant brochure design featuring menu highlights and special offers with vibrant food photography.', 'promotions', 'Singla\'s Restaurant', 2023, 'Adobe Photoshop, Illustrator', TRUE, 3),
('Okaya Electric Scooters Poster', 'Dynamic brand poster for electric scooters emphasizing eco-friendly transportation with modern design elements.', 'brands', 'Okaya', 2023, 'Adobe Photoshop, Illustrator', TRUE, 4);

-- Insert default contact info
INSERT INTO contact_info (email, phone, location, instagram_url, behance_url, linkedin_url, dribbble_url) VALUES
('manisha.designer@email.com', '+91 XXXXX XXXXX', 'India', 
'https://instagram.com/the_venue_veda', 
'https://behance.net/manisha', 
'https://linkedin.com/in/manisha', 
'https://dribbble.com/manisha');
