<?php
require_once 'includes/site_data.php';

// Get dynamic content
$about_data = getAboutData();
$contact_info = getContactInfo();
$site_title = getSiteSetting('site_title', 'Manisha - Graphic Designer');
$footer_copyright = getSiteSetting('footer_copyright', '© 2024 Manisha. All rights reserved.');
$newsletter_text = getSiteSetting('newsletter_text', 'Get design tips and project updates');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact - <?php echo htmlspecialchars($about_data['name'] ?? 'Manisha'); ?> | Graphic Designer</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Playfair+Display:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/responsive.css">
    <style>
        /* Alert Styles */
        .alert {
            padding: 15px 20px;
            margin-bottom: 20px;
            border-radius: 8px;
            border: 1px solid;
            animation: slideDown 0.3s ease-out;
        }
        
        .alert-success {
            background-color: #d4edda;
            border-color: #c3e6cb;
            color: #155724;
        }
        
        .alert-error {
            background-color: #f8d7da;
            border-color: #f5c6cb;
            color: #721c24;
        }
        
        .alert-content {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .alert-icon {
            font-weight: bold;
            font-size: 18px;
        }
        
        .alert-message {
            flex: 1;
        }
        
        .alert-close {
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
            padding: 0;
            width: 24px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            transition: background-color 0.2s;
        }
        
        .alert-close:hover {
            background-color: rgba(0,0,0,0.1);
        }
        
        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
</head>
<body>
    <main class="page-content">
    <!-- Navigation -->
    <nav class="navbar" id="navbar">
        <div class="nav-container">
            <div class="nav-logo">
                <a href="index.php"><?php echo htmlspecialchars($about_data['name'] ?? 'Manisha'); ?></a>
            </div>
            <div class="nav-menu" id="nav-menu">
                <a href="index.php" class="nav-link">Home</a>
                <a href="about.php" class="nav-link">About</a>
                <a href="portfolio.php" class="nav-link">Portfolio</a>
                <a href="contact.php" class="nav-link active">Contact</a>
            </div>
            <div class="hamburger" id="hamburger">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
    </nav>

    <!-- Contact Hero Section -->
    <section class="contact-hero">
        <div class="container">
            <div class="contact-hero-content">
                <h1>Let's <span class="highlight">Connect</span></h1>
                <p class="lead">
                    Ready to bring your vision to life? I'd love to hear about your project 
                    and discuss how we can create something amazing together.
                </p>
            </div>
        </div>
    </section>

    <!-- Contact Content -->
    <section class="contact-content">
        <div class="container">
            <div class="contact-grid">
                <!-- Contact Form -->
                <div class="contact-form-section">
                    <div class="form-header">
                        <h2>Send Me a Message</h2>
                        <p>Fill out the form below and I'll get back to you as soon as possible.</p>
                    </div>
                    
                    <form class="contact-form" id="contact-form">
                        <div class="form-group">
                            <label for="name">Full Name *</label>
                            <input type="text" id="name" name="name" required>
                            <span class="form-error" id="name-error"></span>
                        </div>
                        
                        <div class="form-group">
                            <label for="email">Email Address *</label>
                            <input type="email" id="email" name="email" required>
                            <span class="form-error" id="email-error"></span>
                        </div>
                        
                        <div class="form-group">
                            <label for="phone">Phone Number</label>
                            <input type="tel" id="phone" name="phone">
                            <span class="form-error" id="phone-error"></span>
                        </div>
                        
                        <div class="form-group">
                            <label for="subject">Subject *</label>
                            <select id="subject" name="subject" required>
                                <option value="">Select a subject</option>
                                <option value="brand-design">Brand Design Project</option>
                                <option value="print-design">Print Design</option>
                                <option value="advertising">Advertising Campaign</option>
                                <option value="event-design">Event Design</option>
                                <option value="consultation">Design Consultation</option>
                                <option value="other">Other</option>
                            </select>
                            <span class="form-error" id="subject-error"></span>
                        </div>
                        
                        <div class="form-group">
                            <label for="budget">Project Budget</label>
                            <select id="budget" name="budget">
                                <option value="">Select budget range</option>
                                <option value="under-10k">Under ₹10,000</option>
                                <option value="10k-25k">₹10,000 - ₹25,000</option>
                                <option value="25k-50k">₹25,000 - ₹50,000</option>
                                <option value="50k-100k">₹50,000 - ₹1,00,000</option>
                                <option value="above-100k">Above ₹1,00,000</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="message">Message *</label>
                            <textarea id="message" name="message" rows="6" placeholder="Tell me about your project, timeline, and any specific requirements..." required></textarea>
                            <span class="form-error" id="message-error"></span>
                        </div>
                        
                        <div class="form-group checkbox-group">
                            <label class="checkbox-label">
                                <input type="checkbox" id="newsletter" name="newsletter">
                                <span class="checkmark"></span>
                                Subscribe to my newsletter for design tips and updates
                            </label>
                        </div>
                        
                        <button type="submit" class="btn btn-primary submit-btn">
                            <span class="btn-text">Send Message</span>
                            <span class="btn-loading" style="display: none;">
                                <svg class="spinner" width="20" height="20" viewBox="0 0 24 24">
                                    <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2" fill="none" stroke-dasharray="60" stroke-dashoffset="60" stroke-linecap="round">
                                        <animateTransform attributeName="transform" type="rotate" values="0 12 12;360 12 12" dur="1s" repeatCount="indefinite"/>
                                    </circle>
                                </svg>
                                Sending...
                            </span>
                        </button>
                    </form>
                </div>

                <!-- Contact Information -->
                <div class="contact-info-section">
                    <div class="contact-info">
                        <h2>Get in Touch</h2>
                        <p>
                            I'm always excited to work on new projects and collaborate with 
                            creative minds. Let's discuss how we can bring your vision to life.
                        </p>
                        
                        <div class="contact-methods">
                            <div class="contact-method">
                                <div class="method-icon">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M4 4H20C21.1 4 22 4.9 22 6V18C22 19.1 21.1 20 20 20H4C2.9 20 2 19.1 2 18V6C2 4.9 2.9 4 4 4Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <polyline points="22,6 12,13 2,6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div class="method-content">
                                    <h3>Email</h3>
                                    <p><?php echo htmlspecialchars($contact_info['email'] ?? 'manisha.designer@email.com'); ?></p>
                                    <small>I'll respond within 24 hours</small>
                                </div>
                            </div>
                            
                            <?php if ($contact_info['phone']): ?>
                            <div class="contact-method">
                                <div class="method-icon">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M22 16.92V19.92C22 20.52 21.39 21 20.92 21C9.36 21 0 11.64 0 0.08C0 -0.39 0.48 -1 1.08 -1H4.08C4.68 -1 5.08 -0.39 5.08 0.08C5.08 2.25 5.42 4.34 6.05 6.31C6.22 6.75 6.09 7.24 5.74 7.59L4.21 9.12C6.38 13.29 10.71 17.62 14.88 19.79L16.41 18.26C16.76 17.91 17.25 17.78 17.69 17.95C19.66 18.58 21.75 18.92 23.92 18.92C24.39 18.92 25 19.32 25 19.92Z" fill="currentColor"/>
                                    </svg>
                                </div>
                                <div class="method-content">
                                    <h3>Phone</h3>
                                    <p><?php echo htmlspecialchars($contact_info['phone']); ?></p>
                                    <small>Available Mon-Fri, 9 AM - 6 PM</small>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <div class="contact-method">
                                <div class="method-icon">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M21 10C21 17 12 23 12 23S3 17 3 10C3 5.03 7.03 1 12 1S21 5.03 21 10Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <circle cx="12" cy="10" r="3" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div class="method-content">
                                    <h3>Location</h3>
                                    <p><?php echo htmlspecialchars($contact_info['location'] ?? 'India'); ?></p>
                                    <small>Available for remote work worldwide</small>
                                </div>
                            </div>
                        </div>
                        
                        <div class="social-connect">
                            <h3>Follow My Work</h3>
                            <div class="social-links">
                                <?php if ($contact_info['instagram_url']): ?>
                                <a href="<?php echo htmlspecialchars($contact_info['instagram_url']); ?>" class="social-link instagram" title="Instagram">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                                    </svg>
                                    <span>@the_venue_veda</span>
                                </a>
                                <?php endif; ?>
                                
                                <?php if ($contact_info['behance_url']): ?>
                                <a href="<?php echo htmlspecialchars($contact_info['behance_url']); ?>" class="social-link behance" title="Behance">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M6.938 4.503c.702 0 1.34.06 1.92.188.577.13 1.07.33 1.485.61.41.28.733.65.96 1.12.225.47.34 1.05.34 1.73 0 .74-.17 1.36-.507 1.86-.338.5-.837.9-1.502 1.22.906.26 1.576.72 2.022 1.37.448.66.665 1.45.665 2.36 0 .75-.13 1.39-.41 1.93-.28.55-.67 1-1.16 1.35-.48.348-1.05.6-1.67.76-.62.16-1.25.24-1.89.24H0V4.51h6.938v-.007zM3.495 8.22h2.881c.8 0 1.43-.182 1.89-.544.46-.362.69-.95.69-1.766 0-.39-.09-.73-.26-1.02-.17-.29-.39-.51-.67-.69-.28-.18-.6-.31-.95-.39-.35-.08-.74-.12-1.16-.12H3.495v4.53zm0 6.73h3.367c.93 0 1.67-.24 2.22-.72.55-.48.82-1.15.82-2.02 0-.81-.21-1.41-.63-1.79-.42-.38-1.07-.57-1.95-.57H3.495v5.1zm14.776-8.018c-.74 0-1.37.188-1.89.565-.52.377-.87.932-1.05 1.664h5.255c-.088-.732-.383-1.287-.865-1.664-.482-.377-1.097-.565-1.85-.565zm.865 3.676c0 .45-.08.84-.24 1.17-.16.33-.38.6-.66.81-.28.21-.61.36-.99.45-.38.09-.78.13-1.2.13-.48 0-.92-.05-1.32-.15-.4-.1-.74-.25-1.02-.45-.28-.2-.5-.45-.66-.75-.16-.3-.24-.65-.24-1.05v-.02h5.505c.03-.78-.17-1.37-.6-1.77-.43-.4-.98-.6-1.64-.6-.53 0-.99.12-1.38.37-.39.25-.63.59-.72 1.02h-2.241c.12-.53.33-.99.63-1.38.3-.39.67-.72 1.11-.99.44-.27.93-.48 1.47-.63.54-.15 1.11-.23 1.71-.23.64 0 1.24.08 1.8.24.56.16 1.04.39 1.44.69.4.3.71.67.93 1.11.22.44.33.95.33 1.53v.4zm-6.28-1.05h2.881c.04-.55.25-.98.63-1.29.38-.31.86-.47 1.44-.47.3 0 .58.04.84.13.26.09.48.21.66.36.18.15.32.33.42.54.1.21.15.43.15.66h-6.02z"/>
                                    </svg>
                                    <span>Behance Portfolio</span>
                                </a>
                                <?php endif; ?>
                                
                                <?php if ($contact_info['linkedin_url']): ?>
                                <a href="<?php echo htmlspecialchars($contact_info['linkedin_url']); ?>" class="social-link linkedin" title="LinkedIn">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/>
                                    </svg>
                                    <span>LinkedIn Profile</span>
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="faq-section">
        <div class="container">
            <div class="section-header">
                <h2>Frequently Asked Questions</h2>
                <p>Common questions about working with me</p>
            </div>
            <div class="faq-grid">
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>What types of design projects do you work on?</h3>
                        <button class="faq-toggle">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M6 9L12 15L18 9" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </button>
                    </div>
                    <div class="faq-answer">
                        <p>I specialize in brand identity design, print design, advertising campaigns, event materials, and promotional graphics. My expertise includes pamphlets, brochures, posters, welcome boards, and comprehensive brand design solutions.</p>
                    </div>
                </div>
                
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>What is your typical project timeline?</h3>
                        <button class="faq-toggle">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M6 9L12 15L18 9" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </button>
                    </div>
                    <div class="faq-answer">
                        <p>Project timelines vary depending on complexity. Simple designs like pamphlets typically take 3-5 days, while comprehensive brand identity projects may take 2-3 weeks. I always discuss timelines upfront and keep you updated throughout the process.</p>
                    </div>
                </div>
                
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>Do you provide revisions?</h3>
                        <button class="faq-toggle">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M6 9L12 15L18 9" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </button>
                    </div>
                    <div class="faq-answer">
                        <p>Yes! I include up to 3 rounds of revisions in all my projects to ensure you're completely satisfied with the final result. Additional revisions can be accommodated if needed.</p>
                    </div>
                </div>
                
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>What file formats do you deliver?</h3>
                        <button class="faq-toggle">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M6 9L12 15L18 9" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </button>
                    </div>
                    <div class="faq-answer">
                        <p>I provide final designs in multiple formats including high-resolution PNG, JPEG, PDF for print, and source files (AI, PSD) when requested. All files are optimized for their intended use.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    </main>

    <!-- Footer -->
    <footer class="footer">
        <!-- Footer Background Graphics -->
        <div class="footer-background-graphics">
            <div class="footer-pattern-1"></div>
            <div class="footer-pattern-2"></div>
            <div class="footer-decorative-elements">
                <div class="footer-shape footer-shape-1">
                    <svg width="120" height="120" viewBox="0 0 120 120" fill="none">
                        <circle cx="60" cy="60" r="60" fill="url(#footerGrad1)" opacity="0.1"/>
                        <circle cx="60" cy="60" r="40" fill="url(#footerGrad2)" opacity="0.15"/>
                        <circle cx="60" cy="60" r="20" fill="url(#footerGrad3)" opacity="0.2"/>
                        <defs>
                            <radialGradient id="footerGrad1" cx="50%" cy="50%" r="50%">
                                <stop offset="0%" style="stop-color:#E8B4CB;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#8B5A96;stop-opacity:0" />
                            </radialGradient>
                            <radialGradient id="footerGrad2" cx="50%" cy="50%" r="50%">
                                <stop offset="0%" style="stop-color:#D4A574;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#E8B4CB;stop-opacity:0" />
                            </radialGradient>
                            <radialGradient id="footerGrad3" cx="50%" cy="50%" r="50%">
                                <stop offset="0%" style="stop-color:#8B5A96;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#D4A574;stop-opacity:0" />
                            </radialGradient>
                        </defs>
                    </svg>
                </div>
                <div class="footer-shape footer-shape-2">
                    <svg width="80" height="80" viewBox="0 0 80 80" fill="none">
                        <path d="M40 0L50 30L80 40L50 50L40 80L30 50L0 40L30 30L40 0Z" fill="url(#footerStarGrad)" opacity="0.12"/>
                        <defs>
                            <linearGradient id="footerStarGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" style="stop-color:#E8B4CB;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#D4A574;stop-opacity:1" />
                            </linearGradient>
                        </defs>
                    </svg>
                </div>
                <div class="footer-shape footer-shape-3">
                    <svg width="100" height="100" viewBox="0 0 100 100" fill="none">
                        <polygon points="50,5 65,35 95,35 73,57 80,87 50,70 20,87 27,57 5,35 35,35" fill="url(#footerPolygonGrad)" opacity="0.08"/>
                        <defs>
                            <linearGradient id="footerPolygonGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" style="stop-color:#8B5A96;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#E8B4CB;stop-opacity:1" />
                            </linearGradient>
                        </defs>
                    </svg>
                </div>
                <div class="footer-shape footer-shape-4">
                    <svg width="60" height="60" viewBox="0 0 60 60" fill="none">
                        <rect x="15" y="15" width="30" height="30" rx="8" fill="url(#footerRectGrad)" opacity="0.15" transform="rotate(45 30 30)"/>
                        <defs>
                            <linearGradient id="footerRectGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" style="stop-color:#D4A574;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#8B5A96;stop-opacity:1" />
                            </linearGradient>
                        </defs>
                    </svg>
                </div>
            </div>
        </div>

        <div class="container">
            <div class="footer-content">
                <div class="footer-info">
                    <div class="footer-logo">
                        <svg width="40" height="40" viewBox="0 0 40 40" fill="none" class="footer-logo-icon">
                            <circle cx="20" cy="20" r="20" fill="url(#contactFooterLogoGrad)"/>
                            <path d="M12 15 L20 25 L28 15" stroke="white" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round"/>
                            <circle cx="20" cy="12" r="3" fill="white"/>
                            <defs>
                                <linearGradient id="contactFooterLogoGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                    <stop offset="0%" style="stop-color:#E8B4CB;stop-opacity:1" />
                                    <stop offset="100%" style="stop-color:#8B5A96;stop-opacity:1" />
                                </linearGradient>
                            </defs>
                        </svg>
                        <h3><?php echo htmlspecialchars($about_data['name'] ?? 'Manisha'); ?></h3>
                    </div>
                    <p>Graphic Designer passionate about creating impactful visual experiences that tell compelling stories and connect with audiences.</p>
                    <div class="footer-contact-info">
                        <div class="contact-item">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/>
                            </svg>
                            <span><?php echo htmlspecialchars($contact_info['email'] ?? 'manisha.designer@email.com'); ?></span>
                        </div>
                        <div class="contact-item">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
                            </svg>
                            <span><?php echo htmlspecialchars($contact_info['location'] ?? 'India'); ?></span>
                        </div>
                    </div>
                </div>
                <div class="footer-links">
                    <h4>Quick Links</h4>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="about.php">About</a></li>
                        <li><a href="portfolio.php">Portfolio</a></li>
                        <li><a href="contact.php">Contact</a></li>
                    </ul>
                </div>
                <div class="footer-services">
                    <h4>Services</h4>
                    <ul>
                        <li>Brand Design</li>
                        <li>Print Design</li>
                        <li>Advertising Campaigns</li>
                        <li>Event Design</li>
                    </ul>
                </div>
                <div class="footer-social">
                    <h4>Follow Me</h4>
                    <div class="social-links">
                        <?php if ($contact_info['instagram_url']): ?>
                            <a href="<?php echo htmlspecialchars($contact_info['instagram_url']); ?>" class="social-link instagram">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                        <?php if ($contact_info['behance_url']): ?>
                            <a href="<?php echo htmlspecialchars($contact_info['behance_url']); ?>" class="social-link behance">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M6.938 4.503c.702 0 1.34.06 1.92.188.577.13 1.07.33 1.485.61.41.28.733.65.96 1.12.225.47.34 1.05.34 1.73 0 .74-.17 1.36-.507 1.86-.338.5-.837.9-1.502 1.22.906.26 1.576.72 2.022 1.37.448.66.665 1.45.665 2.36 0 .75-.13 1.39-.41 1.93-.28.55-.67 1-1.16 1.35-.48.348-1.05.6-1.67.76-.62.16-1.25.24-1.89.24H0V4.51h6.938v-.007zM3.495 8.42h2.876c.606 0 1.1-.15 1.48-.45.38-.3.57-.75.57-1.35 0-.28-.06-.51-.18-.69-.12-.18-.29-.32-.51-.42-.21-.1-.46-.17-.75-.21-.29-.04-.61-.06-.94-.06H3.495v3.18zm0 7.17h3.62c.35 0 .67-.04.96-.1.29-.07.54-.17.75-.3.21-.13.37-.3.48-.52.11-.22.17-.48.17-.78 0-.68-.23-1.15-.69-1.4-.46-.25-1.08-.38-1.85-.38H3.495v3.48z"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                        <?php if ($contact_info['linkedin_url']): ?>
                            <a href="<?php echo htmlspecialchars($contact_info['linkedin_url']); ?>" class="social-link linkedin">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                        <?php if ($contact_info['dribbble_url']): ?>
                            <a href="<?php echo htmlspecialchars($contact_info['dribbble_url']); ?>" class="social-link dribbble">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 0C5.374 0 0 5.374 0 12s5.374 12 12 12 12-5.374 12-12S18.626 0 12 0zm7.568 5.302c1.4 1.5 2.252 3.5 2.273 5.698-.653-.126-1.542-.224-2.402-.224-.2 0-.402.002-.604.006-.024-.593-.094-1.164-.194-1.702 1.084-.497 1.736-.78 1.927-.778zm-1.927.778c-.191-.002-.843.281-1.927.778-.1.538-.17 1.109-.194 1.702-.202-.004-.404-.006-.604-.006-.86 0-1.749.098-2.402.224.021-2.198.873-4.198 2.273-5.698 1.5 1.4 2.252 3.5 2.273 5.698-.653-.126-1.542-.224-2.402-.224-.2 0-.402.002-.604.006-.024-.593-.094-1.164-.194-1.702z"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                    </div>
                    <div class="footer-newsletter">
                        <h5>Stay Updated</h5>
                        <p><?php echo htmlspecialchars($newsletter_text); ?></p>
                        <form class="newsletter-form" id="newsletter-form">
                            <input type="email" name="email" placeholder="Enter your email" class="newsletter-input" required>
                            <button type="submit" class="newsletter-btn">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M2.01 21L23 12 2.01 3 2 10l15 2-15 2z"/>
                                </svg>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <div class="footer-bottom-content">
                    <p><?php echo htmlspecialchars($footer_copyright); ?></p>
                    <div class="footer-bottom-links">
                        <a href="#">Privacy Policy</a>
                        <a href="#">Terms of Service</a>
                        <a href="#">Cookies</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <script src="js/main.js"></script>
    <script src="js/contact.js"></script>
    <script>
        // Contact form submission
        document.getElementById('contact-form').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            const submitBtn = this.querySelector('.submit-btn');
            const btnText = submitBtn.querySelector('.btn-text');
            const btnLoading = submitBtn.querySelector('.btn-loading');
            
            // Show loading state
            btnText.style.display = 'none';
            btnLoading.style.display = 'flex';
            submitBtn.disabled = true;
            
            // Clear previous errors and alerts
            document.querySelectorAll('.form-error').forEach(error => error.textContent = '');
            removeAlert();
            
            fetch('api/contact.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showAlert(data.message, 'success');
                    this.reset();
                } else {
                    showAlert(data.message, 'error');
                }
            })
            .catch(error => {
                showAlert('An error occurred. Please try again.', 'error');
            })
            .finally(() => {
                // Reset button state
                btnText.style.display = 'inline';
                btnLoading.style.display = 'none';
                submitBtn.disabled = false;
            });
        });

        // Alert functions
        function showAlert(message, type) {
            removeAlert(); // Remove any existing alert
            
            const alertDiv = document.createElement('div');
            alertDiv.className = `alert alert-${type}`;
            alertDiv.innerHTML = `
                <div class="alert-content">
                    <span class="alert-icon">
                        ${type === 'success' ? '✓' : '⚠'}
                    </span>
                    <span class="alert-message">${message}</span>
                    <button class="alert-close" onclick="removeAlert()">×</button>
                </div>
            `;
            
            // Insert alert at the top of the form section
            const formSection = document.querySelector('.contact-form-section');
            formSection.insertBefore(alertDiv, formSection.firstChild);
            
            // Auto-remove success alerts after 5 seconds
            if (type === 'success') {
                setTimeout(removeAlert, 5000);
            }
        }

        function removeAlert() {
            const existingAlert = document.querySelector('.alert');
            if (existingAlert) {
                existingAlert.remove();
            }
        }

        // Newsletter form submission
        document.getElementById('newsletter-form').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            const button = this.querySelector('.newsletter-btn');
            const input = this.querySelector('.newsletter-input');
            
            button.disabled = true;
            
            fetch('api/newsletter.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    input.value = '';
                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(error => {
                alert('An error occurred. Please try again.');
            })
            .finally(() => {
                button.disabled = false;
            });
        });

        // FAQ functionality
        document.querySelectorAll('.faq-toggle').forEach(button => {
            button.addEventListener('click', function() {
                const faqItem = this.closest('.faq-item');
                const answer = faqItem.querySelector('.faq-answer');
                const isOpen = faqItem.classList.contains('active');
                
                // Close all other FAQ items
                document.querySelectorAll('.faq-item').forEach(item => {
                    item.classList.remove('active');
                    item.querySelector('.faq-answer').style.maxHeight = null;
                });
                
                // Toggle current item
                if (!isOpen) {
                    faqItem.classList.add('active');
                    answer.style.maxHeight = answer.scrollHeight + 'px';
                }
            });
        });
    </script>
</body>
</html>
