<?php
header('Content-Type: application/json');
require_once '../includes/site_data.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

// Get and validate email
$email = sanitizeInput($_POST['email'] ?? '');

if (empty($email)) {
    echo json_encode(['success' => false, 'message' => 'Email is required']);
    exit;
}

if (!validateEmail($email)) {
    echo json_encode(['success' => false, 'message' => 'Please enter a valid email address']);
    exit;
}

// Add to newsletter
if (addNewsletterSubscriber($email)) {
    echo json_encode([
        'success' => true,
        'message' => 'Thank you for subscribing to our newsletter!'
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Sorry, there was an error subscribing. Please try again.'
    ]);
}
?>
