<?php
require_once '../config/auth.php';
require_once '../config/database.php';

$auth = new Auth();
$auth->requireLogin();

$pdo = getDBConnection();

// Get dashboard statistics
try {
    $stats = [];
    
    // Portfolio items count
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM portfolio_items WHERE status = 'active'");
    $stats['portfolio_items'] = $stmt->fetch()['count'];
    
    // Newsletter subscribers count
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM newsletter_subscribers WHERE status = 'active'");
    $stats['subscribers'] = $stmt->fetch()['count'];
    
    // Contact messages count
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM contact_messages WHERE status = 'new'");
    $stats['new_messages'] = $stmt->fetch()['count'];
    
    // Total messages count
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM contact_messages");
    $stats['total_messages'] = $stmt->fetch()['count'];
    
    // Recent messages
    $stmt = $pdo->query("SELECT name, email, subject, created_at FROM contact_messages ORDER BY created_at DESC LIMIT 5");
    $recent_messages = $stmt->fetchAll();
    
    // Recent subscribers
    $stmt = $pdo->query("SELECT email, subscribed_at FROM newsletter_subscribers ORDER BY subscribed_at DESC LIMIT 5");
    $recent_subscribers = $stmt->fetchAll();
    
} catch(PDOException $e) {
    error_log("Dashboard error: " . $e->getMessage());
    $stats = ['portfolio_items' => 0, 'subscribers' => 0, 'new_messages' => 0, 'total_messages' => 0];
    $recent_messages = [];
    $recent_subscribers = [];
}

$user = $auth->getCurrentUser();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Portfolio</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/admin.css">
</head>
<body>
    <div class="admin-wrapper">
        <!-- Sidebar -->
        <nav class="sidebar">
            <div class="sidebar-header">
                <h2>Portfolio Admin</h2>
            </div>
            <ul class="sidebar-menu">
                <li><a href="index.php" class="active"><i>📊</i> Dashboard</a></li>
                <li><a href="about.php"><i>👤</i> About Section</a></li>
                <li><a href="portfolio.php"><i>🎨</i> Portfolio</a></li>
                <li><a href="contact.php"><i>📞</i> Contact Info</a></li>
                <li><a href="messages.php"><i>💬</i> Messages <?php if($stats['new_messages'] > 0): ?><span class="badge"><?php echo $stats['new_messages']; ?></span><?php endif; ?></a></li>
                <li><a href="newsletter.php"><i>📧</i> Newsletter</a></li>
                <li><a href="settings.php"><i>⚙️</i> Settings</a></li>
                <li><a href="logout.php"><i>🚪</i> Logout</a></li>
            </ul>
        </nav>

        <!-- Main Content -->
        <div class="main-content">
            <header class="content-header">
                <h1>Dashboard</h1>
                <div class="user-info">
                    Welcome, <?php echo htmlspecialchars($user['username']); ?>
                </div>
            </header>

            <div class="dashboard-content">
                <!-- Statistics Cards -->
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon">🎨</div>
                        <div class="stat-info">
                            <h3><?php echo $stats['portfolio_items']; ?></h3>
                            <p>Portfolio Items</p>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon">📧</div>
                        <div class="stat-info">
                            <h3><?php echo $stats['subscribers']; ?></h3>
                            <p>Newsletter Subscribers</p>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon">💬</div>
                        <div class="stat-info">
                            <h3><?php echo $stats['new_messages']; ?></h3>
                            <p>New Messages</p>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon">📊</div>
                        <div class="stat-info">
                            <h3><?php echo $stats['total_messages']; ?></h3>
                            <p>Total Messages</p>
                        </div>
                    </div>
                </div>

                <!-- Recent Activity -->
                <div class="activity-grid">
                    <div class="activity-card">
                        <h3>Recent Messages</h3>
                        <div class="activity-list">
                            <?php if (empty($recent_messages)): ?>
                                <p class="no-data">No messages yet</p>
                            <?php else: ?>
                                <?php foreach($recent_messages as $message): ?>
                                    <div class="activity-item">
                                        <div class="activity-info">
                                            <strong><?php echo htmlspecialchars($message['name']); ?></strong>
                                            <p><?php echo htmlspecialchars($message['subject']); ?></p>
                                            <small><?php echo date('M j, Y g:i A', strtotime($message['created_at'])); ?></small>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                        <a href="messages.php" class="view-all">View All Messages</a>
                    </div>
                    
                    <div class="activity-card">
                        <h3>Recent Subscribers</h3>
                        <div class="activity-list">
                            <?php if (empty($recent_subscribers)): ?>
                                <p class="no-data">No subscribers yet</p>
                            <?php else: ?>
                                <?php foreach($recent_subscribers as $subscriber): ?>
                                    <div class="activity-item">
                                        <div class="activity-info">
                                            <strong><?php echo htmlspecialchars($subscriber['email']); ?></strong>
                                            <small><?php echo date('M j, Y g:i A', strtotime($subscriber['subscribed_at'])); ?></small>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                        <a href="newsletter.php" class="view-all">View All Subscribers</a>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="quick-actions">
                    <h3>Quick Actions</h3>
                    <div class="action-buttons">
                        <a href="portfolio.php?action=add" class="action-btn">
                            <i>➕</i>
                            Add Portfolio Item
                        </a>
                        <a href="about.php" class="action-btn">
                            <i>✏️</i>
                            Edit About Section
                        </a>
                        <a href="contact.php" class="action-btn">
                            <i>📞</i>
                            Update Contact Info
                        </a>
                        <a href="../index.php" class="action-btn" target="_blank">
                            <i>🌐</i>
                            View Website
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
