<?php
require_once '../config/auth.php';
require_once '../config/database.php';

$auth = new Auth();
$auth->requireLogin();

$pdo = getDBConnection();
$message = '';
$error = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = sanitizeInput($_POST['email'] ?? '');
    $phone = sanitizeInput($_POST['phone'] ?? '');
    $location = sanitizeInput($_POST['location'] ?? '');
    $address = sanitizeInput($_POST['address'] ?? '');
    $instagram_url = sanitizeInput($_POST['instagram_url'] ?? '');
    $behance_url = sanitizeInput($_POST['behance_url'] ?? '');
    $linkedin_url = sanitizeInput($_POST['linkedin_url'] ?? '');
    $dribbble_url = sanitizeInput($_POST['dribbble_url'] ?? '');
    
    if (empty($email)) {
        $error = 'Email is required.';
    } elseif (!validateEmail($email)) {
        $error = 'Please enter a valid email address.';
    } else {
        try {
            // Check if contact info exists
            $stmt = $pdo->query("SELECT COUNT(*) as count FROM contact_info");
            $count = $stmt->fetch()['count'];
            
            if ($count > 0) {
                // Update existing record
                $sql = "UPDATE contact_info SET email = ?, phone = ?, location = ?, address = ?, instagram_url = ?, behance_url = ?, linkedin_url = ?, dribbble_url = ? WHERE id = (SELECT id FROM (SELECT id FROM contact_info ORDER BY id DESC LIMIT 1) as temp)";
            } else {
                // Insert new record
                $sql = "INSERT INTO contact_info (email, phone, location, address, instagram_url, behance_url, linkedin_url, dribbble_url) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            }
            
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$email, $phone, $location, $address, $instagram_url, $behance_url, $linkedin_url, $dribbble_url]);
            $message = 'Contact information updated successfully!';
        } catch(PDOException $e) {
            $error = 'Database error: ' . $e->getMessage();
        }
    }
}

// Get current contact info
try {
    $stmt = $pdo->query("SELECT * FROM contact_info ORDER BY id DESC LIMIT 1");
    $contact_info = $stmt->fetch();
} catch(PDOException $e) {
    $error = 'Error fetching contact info: ' . $e->getMessage();
    $contact_info = null;
}

$user = $auth->getCurrentUser();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Management - Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/admin.css">
</head>
<body>
    <div class="admin-wrapper">
        <!-- Sidebar -->
        <nav class="sidebar">
            <div class="sidebar-header">
                <h2>Portfolio Admin</h2>
            </div>
            <ul class="sidebar-menu">
                <li><a href="index.php"><i>📊</i> Dashboard</a></li>
                <li><a href="about.php"><i>👤</i> About Section</a></li>
                <li><a href="portfolio.php"><i>🎨</i> Portfolio</a></li>
                <li><a href="contact.php" class="active"><i>📞</i> Contact Info</a></li>
                <li><a href="messages.php"><i>💬</i> Messages</a></li>
                <li><a href="newsletter.php"><i>📧</i> Newsletter</a></li>
                <li><a href="settings.php"><i>⚙️</i> Settings</a></li>
                <li><a href="logout.php"><i>🚪</i> Logout</a></li>
            </ul>
        </nav>

        <!-- Main Content -->
        <div class="main-content">
            <header class="content-header">
                <h1>Contact Information</h1>
                <div class="user-info">
                    Welcome, <?php echo htmlspecialchars($user['username']); ?>
                </div>
            </header>

            <div class="dashboard-content">
                <?php if ($message): ?>
                    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
                <?php endif; ?>
                
                <?php if ($error): ?>
                    <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>

                <!-- Contact Information Form -->
                <div class="form-container">
                    <h3>Update Contact Information</h3>
                    <form method="POST">
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="email">Email Address *</label>
                                <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($contact_info['email'] ?? ''); ?>" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="phone">Phone Number</label>
                                <input type="tel" id="phone" name="phone" value="<?php echo htmlspecialchars($contact_info['phone'] ?? ''); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="location">Location</label>
                                <input type="text" id="location" name="location" value="<?php echo htmlspecialchars($contact_info['location'] ?? ''); ?>" placeholder="e.g., India">
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="address">Full Address</label>
                            <textarea id="address" name="address" rows="3" placeholder="Complete address (optional)"><?php echo htmlspecialchars($contact_info['address'] ?? ''); ?></textarea>
                        </div>
                        
                        <h4 style="margin: 2rem 0 1rem 0; color: #333;">Social Media Links</h4>
                        
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="instagram_url">Instagram URL</label>
                                <input type="url" id="instagram_url" name="instagram_url" value="<?php echo htmlspecialchars($contact_info['instagram_url'] ?? ''); ?>" placeholder="https://instagram.com/username">
                            </div>
                            
                            <div class="form-group">
                                <label for="behance_url">Behance URL</label>
                                <input type="url" id="behance_url" name="behance_url" value="<?php echo htmlspecialchars($contact_info['behance_url'] ?? ''); ?>" placeholder="https://behance.net/username">
                            </div>
                            
                            <div class="form-group">
                                <label for="linkedin_url">LinkedIn URL</label>
                                <input type="url" id="linkedin_url" name="linkedin_url" value="<?php echo htmlspecialchars($contact_info['linkedin_url'] ?? ''); ?>" placeholder="https://linkedin.com/in/username">
                            </div>
                            
                            <div class="form-group">
                                <label for="dribbble_url">Dribbble URL</label>
                                <input type="url" id="dribbble_url" name="dribbble_url" value="<?php echo htmlspecialchars($contact_info['dribbble_url'] ?? ''); ?>" placeholder="https://dribbble.com/username">
                            </div>
                        </div>
                        
                        <div class="form-actions">
                            <button type="submit" class="btn btn-primary">Update Contact Information</button>
                            <a href="../contact.php" class="btn btn-secondary" target="_blank">Preview Contact Page</a>
                        </div>
                    </form>
                </div>

                <!-- Current Information Display -->
                <?php if ($contact_info): ?>
                <div class="form-container">
                    <h3>Current Contact Information</h3>
                    <div class="info-display">
                        <div class="info-grid">
                            <div class="info-item">
                                <strong>Email:</strong>
                                <span><?php echo htmlspecialchars($contact_info['email']); ?></span>
                            </div>
                            
                            <?php if ($contact_info['phone']): ?>
                            <div class="info-item">
                                <strong>Phone:</strong>
                                <span><?php echo htmlspecialchars($contact_info['phone']); ?></span>
                            </div>
                            <?php endif; ?>
                            
                            <?php if ($contact_info['location']): ?>
                            <div class="info-item">
                                <strong>Location:</strong>
                                <span><?php echo htmlspecialchars($contact_info['location']); ?></span>
                            </div>
                            <?php endif; ?>
                            
                            <?php if ($contact_info['address']): ?>
                            <div class="info-item">
                                <strong>Address:</strong>
                                <span><?php echo nl2br(htmlspecialchars($contact_info['address'])); ?></span>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <h4 style="margin: 1.5rem 0 1rem 0;">Social Media Links</h4>
                        <div class="social-links-display">
                            <?php if ($contact_info['instagram_url']): ?>
                                <a href="<?php echo htmlspecialchars($contact_info['instagram_url']); ?>" target="_blank" class="social-link-item">
                                    <span>📷</span> Instagram
                                </a>
                            <?php endif; ?>
                            
                            <?php if ($contact_info['behance_url']): ?>
                                <a href="<?php echo htmlspecialchars($contact_info['behance_url']); ?>" target="_blank" class="social-link-item">
                                    <span>🎨</span> Behance
                                </a>
                            <?php endif; ?>
                            
                            <?php if ($contact_info['linkedin_url']): ?>
                                <a href="<?php echo htmlspecialchars($contact_info['linkedin_url']); ?>" target="_blank" class="social-link-item">
                                    <span>💼</span> LinkedIn
                                </a>
                            <?php endif; ?>
                            
                            <?php if ($contact_info['dribbble_url']): ?>
                                <a href="<?php echo htmlspecialchars($contact_info['dribbble_url']); ?>" target="_blank" class="social-link-item">
                                    <span>🏀</span> Dribbble
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <style>
        .info-display {
            background: #f8f9fa;
            padding: 1.5rem;
            border-radius: 8px;
            border: 1px solid #e1e1e1;
        }
        
        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem;
            margin-bottom: 1rem;
        }
        
        .info-item {
            display: flex;
            flex-direction: column;
            gap: 0.25rem;
        }
        
        .info-item strong {
            color: #8B5A96;
            font-size: 0.9rem;
        }
        
        .info-item span {
            color: #333;
        }
        
        .social-links-display {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
        }
        
        .social-link-item {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            background: white;
            border: 1px solid #e1e1e1;
            border-radius: 6px;
            text-decoration: none;
            color: #333;
            transition: all 0.3s ease;
        }
        
        .social-link-item:hover {
            background: #8B5A96;
            color: white;
            transform: translateY(-2px);
        }
        
        .form-actions {
            display: flex;
            gap: 1rem;
            margin-top: 2rem;
        }
    </style>
</body>
</html>
