<?php
require_once 'includes/site_data.php';

// Get dynamic content
$about_data = getAboutData();
$contact_info = getContactInfo();
$site_title = getSiteSetting('site_title', 'About - Manisha | Graphic Designer');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($site_title); ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/responsive.css">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar" id="navbar">
        <div class="nav-container">
            <div class="nav-logo">
                <a href="index.php"><?php echo htmlspecialchars($about_data['name'] ?? 'Manisha'); ?></a>
            </div>
            <div class="nav-menu" id="nav-menu">
                <a href="index.php" class="nav-link">Home</a>
                <a href="about.php" class="nav-link active">About</a>
                <a href="portfolio.php" class="nav-link">Portfolio</a>
                <a href="contact.php" class="nav-link">Contact</a>
            </div>
            <div class="hamburger" id="hamburger">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
    </nav>

    <!-- About Hero Section -->
    <section class="about-hero">
        <div class="container">
            <div class="about-hero-content">
                <div class="about-hero-text">
                <h1>About <span class="highlight"><?php echo safeOutputWithDecode($about_data['name'] ?? 'Manisha'); ?></span></h1>
                <p class="lead">
                    <?php echo safeOutputWithDecode($about_data['hero_description'] ?? 'A passionate graphic designer with a keen eye for detail and a love for creating impactful visual experiences that tell compelling stories.'); ?>
                </p>
                </div>
                <div class="about-hero-image">
                    <div class="image-placeholder">
                        <?php if ($about_data && $about_data['profile_image']): ?>
                            <img src="<?php echo htmlspecialchars($about_data['profile_image']); ?>" alt="<?php echo htmlspecialchars($about_data['name']); ?>" style="width: 400px; height: 400px; object-fit: cover; border-radius: 50%;">
                        <?php else: ?>
                            <svg width="400" height="400" viewBox="0 0 400 400" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <circle cx="200" cy="200" r="200" fill="#f8f9fa"/>
                                <circle cx="200" cy="160" r="60" fill="#28a745"/>
                                <path d="M120 280 Q200 220 280 280 Q280 320 200 350 Q120 320 120 280" fill="#28a745"/>
                                <circle cx="170" cy="140" r="8" fill="white"/>
                                <circle cx="230" cy="140" r="8" fill="white"/>
                                <path d="M180 180 Q200 200 220 180" stroke="white" stroke-width="4" fill="none"/>
                            </svg>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- About Story Section -->
    <section class="about-story">
        <div class="container">
            <div class="story-content">
                <div class="story-text">
                    <h2>My Story</h2>
                    <p>
                        <?php echo nl2br(safeOutputWithDecode($about_data['bio'] ?? 'I feel very connected to advertising. I am passionate about brand design and print design. My goal is to make my mark in digital media and tech spaces. I would love to work with people and companies who will give me an opportunity to flex my sleek and polished style.')); ?>
                    </p>
                    <p>
                        My journey in graphic design began with a fascination for how visual elements can 
                        communicate powerful messages. Over the years, I've developed expertise in creating 
                        compelling advertisements, memorable brand identities, and engaging print materials 
                        that resonate with audiences.
                    </p>
                    <p>
                        Reach out if you think we can create impactful visual art together. I'm always 
                        excited to collaborate on projects that challenge creativity and push the boundaries 
                        of visual storytelling.
                    </p>
                </div>
                <div class="story-highlights">
                    <div class="highlight-item">
                        <div class="highlight-icon">
                            <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M24 4L29.09 14.26L40 16L32 23.74L34.18 34.62L24 29.27L13.82 34.62L16 23.74L8 16L18.91 14.26L24 4Z" fill="#28a745"/>
                            </svg>
                        </div>
                        <h3>Creative Excellence</h3>
                        <p>Committed to delivering innovative and visually striking designs that exceed expectations.</p>
                    </div>
                    <div class="highlight-item">
                        <div class="highlight-icon">
                            <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M24 2C13.5 2 5 10.5 5 21C5 31.5 13.5 40 24 40C34.5 40 43 31.5 43 21C43 10.5 34.5 2 24 2ZM24 36C15.7 36 9 29.3 9 21C9 12.7 15.7 6 24 6C32.3 6 39 12.7 39 21C39 29.3 32.3 36 24 36Z" fill="#28a745"/>
                                <path d="M24 12C19.6 12 16 15.6 16 20C16 24.4 19.6 28 24 28C28.4 28 32 24.4 32 20C32 15.6 28.4 12 24 12Z" fill="#28a745"/>
                            </svg>
                        </div>
                        <h3>Brand Focus</h3>
                        <p>Specializing in brand identity and advertising that creates lasting impressions.</p>
                    </div>
                    <div class="highlight-item">
                        <div class="highlight-icon">
                            <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M40 8H8C5.8 8 4 9.8 4 12V36C4 38.2 5.8 40 8 40H40C42.2 40 44 38.2 44 36V12C44 9.8 42.2 8 40 8ZM40 36H8V16H40V36Z" fill="#28a745"/>
                                <path d="M12 20H20V24H12V20ZM12 28H36V32H12V28ZM24 20H36V24H24V20Z" fill="#28a745"/>
                            </svg>
                        </div>
                        <h3>Print Expertise</h3>
                        <p>Extensive experience in print design, from brochures to large-format displays.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Skills Section -->
    <section class="skills-section">
        <div class="container">
            <div class="section-header">
                <h2>Skills & Expertise</h2>
                <p>Tools and technologies I use to bring creative visions to life</p>
            </div>
            <div class="skills-grid">
                <div class="skill-category">
                    <h3>Design Software</h3>
                    <div class="skill-list">
                        <div class="skill-item">
                            <span class="skill-name">Adobe Photoshop</span>
                            <div class="skill-bar">
                                <div class="skill-progress" style="width: 95%"></div>
                            </div>
                        </div>
                        <div class="skill-item">
                            <span class="skill-name">Adobe Illustrator</span>
                            <div class="skill-bar">
                                <div class="skill-progress" style="width: 90%"></div>
                            </div>
                        </div>
                        <div class="skill-item">
                            <span class="skill-name">Adobe InDesign</span>
                            <div class="skill-bar">
                                <div class="skill-progress" style="width: 85%"></div>
                            </div>
                        </div>
                        <div class="skill-item">
                            <span class="skill-name">Figma</span>
                            <div class="skill-bar">
                                <div class="skill-progress" style="width: 80%"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="skill-category">
                    <h3>Design Specialties</h3>
                    <div class="skill-list">
                        <div class="skill-item">
                            <span class="skill-name">Brand Identity</span>
                            <div class="skill-bar">
                                <div class="skill-progress" style="width: 92%"></div>
                            </div>
                        </div>
                        <div class="skill-item">
                            <span class="skill-name">Print Design</span>
                            <div class="skill-bar">
                                <div class="skill-progress" style="width: 95%"></div>
                            </div>
                        </div>
                        <div class="skill-item">
                            <span class="skill-name">Advertising</span>
                            <div class="skill-bar">
                                <div class="skill-progress" style="width: 88%"></div>
                            </div>
                        </div>
                        <div class="skill-item">
                            <span class="skill-name">Layout Design</span>
                            <div class="skill-bar">
                                <div class="skill-progress" style="width: 90%"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Experience Timeline -->
    <section class="experience-section">
        <div class="container">
            <div class="section-header">
                <h2>Experience & Journey</h2>
                <p>Key milestones in my design career</p>
            </div>
            <div class="timeline">
                <div class="timeline-item">
                    <div class="timeline-marker"></div>
                    <div class="timeline-content">
                        <h3>Freelance Graphic Designer</h3>
                        <span class="timeline-date">2022 - Present</span>
                        <p>
                            Working with diverse clients on brand identity, advertising campaigns, 
                            and print design projects. Specialized in creating impactful visual 
                            solutions for businesses and events.
                        </p>
                        <ul>
                            <li>LIC Advertisement Campaigns</li>
                            <li>Wedding Welcome Board Designs</li>
                            <li>Restaurant & School Promotional Materials</li>
                            <li>Brand Poster Designs</li>
                        </ul>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-marker"></div>
                    <div class="timeline-content">
                        <h3>Junior Graphic Designer</h3>
                        <span class="timeline-date">2021 - 2022</span>
                        <p>
                            Gained valuable experience in a collaborative environment, working on 
                            various print and digital design projects while developing my signature 
                            sleek and polished style.
                        </p>
                        <ul>
                            <li>Brand Identity Development</li>
                            <li>Marketing Collateral Design</li>
                            <li>Client Presentation Materials</li>
                        </ul>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-marker"></div>
                    <div class="timeline-content">
                        <h3>Design Education</h3>
                        <span class="timeline-date">2019 - 2021</span>
                        <p>
                            Completed comprehensive training in graphic design fundamentals, 
                            typography, color theory, and industry-standard software applications.
                        </p>
                        <ul>
                            <li>Design Principles & Theory</li>
                            <li>Adobe Creative Suite Mastery</li>
                            <li>Print Production Techniques</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Call to Action -->
    <section class="about-cta">
        <div class="container">
            <div class="cta-content">
                <h2>Let's Create Something Amazing Together</h2>
                <p>
                    Ready to bring your vision to life? I'm always excited to work on new projects 
                    and collaborate with creative minds who appreciate quality design.
                </p>
                <div class="cta-buttons">
                    <a href="portfolio.php" class="btn btn-primary">View My Work</a>
                    <a href="contact.php" class="btn btn-secondary">Get In Touch</a>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <!-- Footer Background Graphics -->
        <div class="footer-background-graphics">
            <div class="footer-pattern-1"></div>
            <div class="footer-pattern-2"></div>
            <div class="footer-decorative-elements">
                <div class="footer-shape footer-shape-1">
                    <svg width="120" height="120" viewBox="0 0 120 120" fill="none">
                        <circle cx="60" cy="60" r="60" fill="url(#footerGrad1)" opacity="0.1"/>
                        <circle cx="60" cy="60" r="40" fill="url(#footerGrad2)" opacity="0.15"/>
                        <circle cx="60" cy="60" r="20" fill="url(#footerGrad3)" opacity="0.2"/>
                        <defs>
                            <radialGradient id="footerGrad1" cx="50%" cy="50%" r="50%">
                                <stop offset="0%" style="stop-color:#E8B4CB;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#8B5A96;stop-opacity:0" />
                            </radialGradient>
                            <radialGradient id="footerGrad2" cx="50%" cy="50%" r="50%">
                                <stop offset="0%" style="stop-color:#D4A574;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#E8B4CB;stop-opacity:0" />
                            </radialGradient>
                            <radialGradient id="footerGrad3" cx="50%" cy="50%" r="50%">
                                <stop offset="0%" style="stop-color:#8B5A96;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#D4A574;stop-opacity:0" />
                            </radialGradient>
                        </defs>
                    </svg>
                </div>
                <div class="footer-shape footer-shape-2">
                    <svg width="80" height="80" viewBox="0 0 80 80" fill="none">
                        <path d="M40 0L50 30L80 40L50 50L40 80L30 50L0 40L30 30L40 0Z" fill="url(#footerStarGrad)" opacity="0.12"/>
                        <defs>
                            <linearGradient id="footerStarGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" style="stop-color:#E8B4CB;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#D4A574;stop-opacity:1" />
                            </linearGradient>
                        </defs>
                    </svg>
                </div>
                <div class="footer-shape footer-shape-3">
                    <svg width="100" height="100" viewBox="0 0 100 100" fill="none">
                        <polygon points="50,5 65,35 95,35 73,57 80,87 50,70 20,87 27,57 5,35 35,35" fill="url(#footerPolygonGrad)" opacity="0.08"/>
                        <defs>
                            <linearGradient id="footerPolygonGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" style="stop-color:#8B5A96;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#E8B4CB;stop-opacity:1" />
                            </linearGradient>
                        </defs>
                    </svg>
                </div>
                <div class="footer-shape footer-shape-4">
                    <svg width="60" height="60" viewBox="0 0 60 60" fill="none">
                        <rect x="15" y="15" width="30" height="30" rx="8" fill="url(#footerRectGrad)" opacity="0.15" transform="rotate(45 30 30)"/>
                        <defs>
                            <linearGradient id="footerRectGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" style="stop-color:#D4A574;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#8B5A96;stop-opacity:1" />
                            </linearGradient>
                        </defs>
                    </svg>
                </div>
            </div>
        </div>

        <div class="container">
            <div class="footer-content">
                <div class="footer-info">
                    <div class="footer-logo">
                        <svg width="40" height="40" viewBox="0 0 40 40" fill="none" class="footer-logo-icon">
                            <circle cx="20" cy="20" r="20" fill="url(#logoGrad)"/>
                            <path d="M12 15 L20 25 L28 15" stroke="white" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round"/>
                            <circle cx="20" cy="12" r="3" fill="white"/>
                            <defs>
                                <linearGradient id="logoGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                    <stop offset="0%" style="stop-color:#E8B4CB;stop-opacity:1" />
                                    <stop offset="100%" style="stop-color:#8B5A96;stop-opacity:1" />
                                </linearGradient>
                            </defs>
                        </svg>
                        <h3><?php echo htmlspecialchars($about_data['name'] ?? 'Manisha'); ?></h3>
                    </div>
                    <p>Graphic Designer passionate about creating impactful visual experiences that tell compelling stories and connect with audiences.</p>
                    <div class="footer-contact-info">
                        <div class="contact-item">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/>
                            </svg>
                            <span><?php echo htmlspecialchars($contact_info['email'] ?? 'manisha.designer@email.com'); ?></span>
                        </div>
                        <div class="contact-item">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
                            </svg>
                            <span><?php echo htmlspecialchars($contact_info['location'] ?? 'India'); ?></span>
                        </div>
                    </div>
                </div>
                <div class="footer-links">
                    <h4>Quick Links</h4>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="about.php">About</a></li>
                        <li><a href="portfolio.php">Portfolio</a></li>
                        <li><a href="contact.php">Contact</a></li>
                    </ul>
                </div>
                <div class="footer-services">
                    <h4>Services</h4>
                    <ul>
                        <li>Brand Design</li>
                        <li>Print Design</li>
                        <li>Advertising Campaigns</li>
                        <li>Event Design</li>
                    </ul>
                </div>
                <div class="footer-social">
                    <h4>Follow Me</h4>
                    <div class="social-links">
                        <?php if ($contact_info['instagram_url']): ?>
                            <a href="<?php echo htmlspecialchars($contact_info['instagram_url']); ?>" class="social-link instagram">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                        <?php if ($contact_info['behance_url']): ?>
                            <a href="<?php echo htmlspecialchars($contact_info['behance_url']); ?>" class="social-link behance">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M6.938 4.503c.702 0 1.34.06 1.92.188.577.13 1.07.33 1.485.61.41.28.733.65.96 1.12.225.47.34 1.05.34 1.73 0 .74-.17 1.36-.507 1.86-.338.5-.837.9-1.502 1.22.906.26 1.576.72 2.022 1.37.448.66.665 1.45.665 2.36 0 .75-.13 1.39-.41 1.93-.28.55-.67 1-1.16 1.35-.48.348-1.05.6-1.67.76-.62.16-1.25.24-1.89.24H0V4.51h6.938v-.007zM3.495 8.42h2.876c.606 0 1.1-.15 1.48-.45.38-.3.57-.75.57-1.35 0-.28-.06-.51-.18-.69-.12-.18-.29-.32-.51-.42-.21-.1-.46-.17-.75-.21-.29-.04-.61-.06-.94-.06H3.495v3.18zm0 7.17h3.62c.35 0 .67-.04.96-.1.29-.07.54-.17.75-.3.21-.13.37-.3.48-.52.11-.22.17-.48.17-.78 0-.68-.23-1.15-.69-1.4-.46-.25-1.08-.38-1.85-.38H3.495v3.48z"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                        <?php if ($contact_info['linkedin_url']): ?>
                            <a href="<?php echo htmlspecialchars($contact_info['linkedin_url']); ?>" class="social-link linkedin">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                        <?php if ($contact_info['dribbble_url']): ?>
                            <a href="<?php echo htmlspecialchars($contact_info['dribbble_url']); ?>" class="social-link dribbble">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 0C5.374 0 0 5.374 0 12s5.374 12 12 12 12-5.374 12-12S18.626 0 12 0zm7.568 5.302c1.4 1.5 2.252 3.5 2.273 5.698-.653-.126-1.542-.224-2.402-.224-.2 0-.402.002-.604.006-.024-.593-.094-1.164-.194-1.702 1.084-.497 1.736-.78 1.927-.778zm-1.927.778c-.191-.002-.843.281-1.927.778-.1.538-.17 1.109-.194 1.702-.202-.004-.404-.006-.604-.006-.86 0-1.749.098-2.402.224.021-2.198.873-4.198 2.273-5.698 1.5 1.4 2.252 3.5 2.273 5.698-.653-.126-1.542-.224-2.402-.224-.2 0-.402.002-.604.006-.024-.593-.094-1.164-.194-1.702z"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                    </div>
                    <div class="footer-newsletter">
                        <h5>Stay Updated</h5>
                        <p>Get design tips and project updates</p>
                        <div class="newsletter-form">
                            <input type="email" placeholder="Enter your email" class="newsletter-input">
                            <button type="submit" class="newsletter-btn">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M2.01 21L23 12 2.01 3 2 10l15 2-15 2z"/>
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <div class="footer-bottom-content">
                    <p>&copy; 2024 Manisha. All rights reserved.</p>
                    <div class="footer-bottom-links">
                        <a href="#">Privacy Policy</a>
                        <a href="#">Terms of Service</a>
                        <a href="#">Cookies</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <script src="js/main.js"></script>
</body>
</html>
