# Portfolio Website Dynamic Backend Setup Instructions

## Overview
This setup will convert your static portfolio website into a dynamic PHP + MySQL system with a complete admin panel for content management.

## Prerequisites
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Web server (Apache/Nginx) with PHP support
- phpMyAdmin or similar database management tool (optional)

## Installation Steps

### 1. Database Setup
1. Create a new MySQL database named `portfolio_db`
2. Import the database schema:
   ```sql
   mysql -u your_username -p portfolio_db < database_schema.sql
   ```
   Or use phpMyAdmin to import the `database_schema.sql` file

### 2. Configuration
1. Update database credentials in `config/database.php`:
   ```php
   define('DB_HOST', 'localhost');
   define('DB_NAME', 'portfolio_db');
   define('DB_USER', 'your_username');
   define('DB_PASS', 'your_password');
   ```

### 3. File Permissions
1. Create uploads directory and set permissions:
   ```bash
   mkdir uploads
   mkdir uploads/portfolio
   chmod 755 uploads
   chmod 755 uploads/portfolio
   ```

### 4. Admin Access
- **Default Admin Login:**
  - Username: `admin`
  - Password: `admin123`
- **Admin Panel URL:** `your-domain.com/admin/`

### 5. File Structure
```
portfolio/
├── config/
│   ├── database.php
│   └── auth.php
├── admin/
│   ├── login.php
│   ├── index.php
│   ├── portfolio.php
│   ├── logout.php
│   └── assets/
│       └── admin.css
├── includes/
│   ├── site_data.php
│   └── portfolio_data.php
├── api/
│   ├── contact.php
│   └── newsletter.php
├── uploads/
│   └── portfolio/
├── index.php (converted from index.html)
├── about.php (to be converted)
├── portfolio.php (to be converted)
├── contact.php (to be converted)
└── database_schema.sql
```

## Features Implemented

### Admin Panel Features
- ✅ **Dashboard**: Overview with statistics and recent activity
- ✅ **Portfolio Management**: Add/edit/delete portfolio items with image uploads
- ✅ **Authentication**: Secure login system with session management
- ✅ **Responsive Design**: Mobile-friendly admin interface

### Frontend Features
- ✅ **Dynamic Content**: All content loaded from database
- ✅ **Newsletter Signup**: AJAX form submission
- ✅ **Contact Form**: Form processing with database storage
- ✅ **Image Management**: Secure file upload system
- ✅ **SEO Friendly**: Dynamic meta tags and content

### Security Features
- ✅ **SQL Injection Protection**: Prepared statements
- ✅ **XSS Protection**: Input sanitization
- ✅ **File Upload Security**: Type and size validation
- ✅ **Password Hashing**: Secure password storage
- ✅ **Session Management**: Secure admin sessions

## Next Steps

### Remaining Files to Convert
1. **about.php** - Convert about.html to dynamic PHP
2. **portfolio.php** - Convert portfolio.html to dynamic PHP  
3. **contact.php** - Convert contact.html to dynamic PHP

### Additional Admin Features to Implement
1. **About Section Management** - Edit bio, skills, experience
2. **Contact Info Management** - Update contact details and social links
3. **Messages Management** - View and manage contact form submissions
4. **Newsletter Management** - View and manage subscribers
5. **Settings Management** - Site-wide settings and configuration

## Testing Checklist

### Database Connection
- [ ] Database connection successful
- [ ] All tables created properly
- [ ] Default data inserted

### Admin Panel
- [ ] Login page accessible
- [ ] Admin authentication working
- [ ] Dashboard displays statistics
- [ ] Portfolio management functional
- [ ] Image upload working

### Frontend
- [ ] Dynamic content loading
- [ ] Newsletter signup working
- [ ] Contact form processing
- [ ] Responsive design maintained

## Troubleshooting

### Common Issues
1. **Database Connection Error**
   - Check database credentials in `config/database.php`
   - Ensure MySQL service is running
   - Verify database exists

2. **File Upload Issues**
   - Check folder permissions (755 for uploads/)
   - Verify PHP upload settings in php.ini
   - Ensure sufficient disk space

3. **Admin Login Issues**
   - Use default credentials: admin/admin123
   - Check session configuration
   - Clear browser cache/cookies

### File Permissions
```bash
# Set correct permissions
chmod 644 *.php
chmod 644 config/*.php
chmod 644 includes/*.php
chmod 644 api/*.php
chmod 755 admin/
chmod 644 admin/*.php
chmod 755 uploads/
chmod 755 uploads/portfolio/
```

## Security Recommendations

1. **Change Default Password**: Update admin password immediately
2. **Database Security**: Use strong database credentials
3. **File Permissions**: Set restrictive file permissions
4. **SSL Certificate**: Use HTTPS in production
5. **Regular Updates**: Keep PHP and MySQL updated
6. **Backup Strategy**: Implement regular database backups

## Support
For issues or questions, refer to the code comments or check the error logs in your web server.
